/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.composite;

import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.ICompositeDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.SimpleSetter;
import ca.uhn.fhir.model.dstu.composite.PeriodDt;
import ca.uhn.fhir.model.dstu.valueset.ContactSystemEnum;
import ca.uhn.fhir.model.dstu.valueset.ContactUseEnum;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;

@DatatypeDef(name="ContactDt")
public class ContactDt
extends BaseIdentifiableElement
implements ICompositeDatatype {
    @Child(name="system", type={CodeDt.class}, order=0, min=0, max=1)
    @Description(shortDefinition="phone | fax | email | url", formalDefinition="Telecommunications form for contact - what communications system is required to make use of the contact")
    private BoundCodeDt<ContactSystemEnum> mySystem;
    @Child(name="value", type={StringDt.class}, order=1, min=0, max=1)
    @Description(shortDefinition="The actual contact details", formalDefinition="The actual contact details, in a form that is meaningful to the designated communication system (i.e. phone number or email address).")
    private StringDt myValue;
    @Child(name="use", type={CodeDt.class}, order=2, min=0, max=1)
    @Description(shortDefinition="home | work | temp | old | mobile - purpose of this address", formalDefinition="Identifies the purpose for the address")
    private BoundCodeDt<ContactUseEnum> myUse;
    @Child(name="period", type={PeriodDt.class}, order=3, min=0, max=1)
    @Description(shortDefinition="Time period when the contact was/is in use", formalDefinition="Time period when the contact was/is in use")
    private PeriodDt myPeriod;

    public ContactDt() {
    }

    @SimpleSetter
    public ContactDt(@SimpleSetter.Parameter(name="theValue") String theValue) {
        this.setValue(theValue);
    }

    @SimpleSetter
    public ContactDt(@SimpleSetter.Parameter(name="theContactUse") ContactUseEnum theContactUse, @SimpleSetter.Parameter(name="theValue") String theValue) {
        this.setUse(theContactUse);
        this.setValue(theValue);
    }

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.mySystem, this.myValue, this.myUse, this.myPeriod});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.mySystem, this.myValue, this.myUse, this.myPeriod});
    }

    public BoundCodeDt<ContactSystemEnum> getSystem() {
        if (this.mySystem == null) {
            this.mySystem = new BoundCodeDt(ContactSystemEnum.VALUESET_BINDER);
        }
        return this.mySystem;
    }

    public BoundCodeDt<ContactSystemEnum> getSystemElement() {
        if (this.mySystem == null) {
            this.mySystem = new BoundCodeDt(ContactSystemEnum.VALUESET_BINDER);
        }
        return this.mySystem;
    }

    public ContactDt setSystem(BoundCodeDt<ContactSystemEnum> theValue) {
        this.mySystem = theValue;
        return this;
    }

    public ContactDt setSystem(ContactSystemEnum theValue) {
        this.getSystem().setValueAsEnum((Enum)theValue);
        return this;
    }

    public StringDt getValue() {
        if (this.myValue == null) {
            this.myValue = new StringDt();
        }
        return this.myValue;
    }

    public StringDt getValueElement() {
        if (this.myValue == null) {
            this.myValue = new StringDt();
        }
        return this.myValue;
    }

    public ContactDt setValue(StringDt theValue) {
        this.myValue = theValue;
        return this;
    }

    public ContactDt setValue(String theString) {
        this.myValue = new StringDt(theString);
        return this;
    }

    public BoundCodeDt<ContactUseEnum> getUse() {
        if (this.myUse == null) {
            this.myUse = new BoundCodeDt(ContactUseEnum.VALUESET_BINDER);
        }
        return this.myUse;
    }

    public BoundCodeDt<ContactUseEnum> getUseElement() {
        if (this.myUse == null) {
            this.myUse = new BoundCodeDt(ContactUseEnum.VALUESET_BINDER);
        }
        return this.myUse;
    }

    public ContactDt setUse(BoundCodeDt<ContactUseEnum> theValue) {
        this.myUse = theValue;
        return this;
    }

    public ContactDt setUse(ContactUseEnum theValue) {
        this.getUse().setValueAsEnum((Enum)theValue);
        return this;
    }

    public PeriodDt getPeriod() {
        if (this.myPeriod == null) {
            this.myPeriod = new PeriodDt();
        }
        return this.myPeriod;
    }

    public PeriodDt getPeriodElement() {
        if (this.myPeriod == null) {
            this.myPeriod = new PeriodDt();
        }
        return this.myPeriod;
    }

    public ContactDt setPeriod(PeriodDt theValue) {
        this.myPeriod = theValue;
        return this;
    }
}

