/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.composite;

import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.ICompositeDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.dstu.composite.CodingDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;

@DatatypeDef(name="CodeableConceptDt")
public class CodeableConceptDt
extends BaseIdentifiableElement
implements ICompositeDatatype {
    @Child(name="coding", type={CodingDt.class}, order=0, min=0, max=-1)
    @Description(shortDefinition="Code defined by a terminology system", formalDefinition="A reference to a code defined by a terminology system")
    private List<CodingDt> myCoding;
    @Child(name="text", type={StringDt.class}, order=1, min=0, max=1)
    @Description(shortDefinition="Plain text representation of the concept", formalDefinition="A human language representation of the concept as seen/selected/uttered by the user who entered the data and/or which represents the intended meaning of the user")
    private StringDt myText;

    public CodeableConceptDt() {
    }

    public CodeableConceptDt(String theSystem, String theCode) {
        this.addCoding().setSystem(theSystem).setCode(theCode);
    }

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myCoding, this.myText});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myCoding, this.myText});
    }

    public List<CodingDt> getCoding() {
        if (this.myCoding == null) {
            this.myCoding = new ArrayList<CodingDt>();
        }
        return this.myCoding;
    }

    public List<CodingDt> getCodingElement() {
        if (this.myCoding == null) {
            this.myCoding = new ArrayList<CodingDt>();
        }
        return this.myCoding;
    }

    public CodeableConceptDt setCoding(List<CodingDt> theValue) {
        this.myCoding = theValue;
        return this;
    }

    public CodingDt addCoding() {
        CodingDt newType = new CodingDt();
        this.getCoding().add(newType);
        return newType;
    }

    public CodingDt getCodingFirstRep() {
        if (this.getCoding().isEmpty()) {
            return this.addCoding();
        }
        return this.getCoding().get(0);
    }

    public StringDt getText() {
        if (this.myText == null) {
            this.myText = new StringDt();
        }
        return this.myText;
    }

    public StringDt getTextElement() {
        if (this.myText == null) {
            this.myText = new StringDt();
        }
        return this.myText;
    }

    public CodeableConceptDt setText(StringDt theValue) {
        this.myText = theValue;
        return this;
    }

    public CodeableConceptDt setText(String theString) {
        this.myText = new StringDt(theString);
        return this;
    }
}

