/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.composite;

import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.ICompositeDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.primitive.Base64BinaryDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.IntegerDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.model.primitive.UriDt;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;

@DatatypeDef(name="AttachmentDt")
public class AttachmentDt
extends BaseIdentifiableElement
implements ICompositeDatatype {
    @Child(name="contentType", type={CodeDt.class}, order=0, min=1, max=1)
    @Description(shortDefinition="Mime type of the content, with charset etc.", formalDefinition="Identifies the type of the data in the attachment and allows a method to be chosen to interpret or render the data. Includes mime type parameters such as charset where appropriate")
    private CodeDt myContentType;
    @Child(name="language", type={CodeDt.class}, order=1, min=0, max=1)
    @Description(shortDefinition="Human language of the content (BCP-47)", formalDefinition="The human language of the content. The value can be any valid value according to BCP 47")
    private CodeDt myLanguage;
    @Child(name="data", type={Base64BinaryDt.class}, order=2, min=0, max=1)
    @Description(shortDefinition="Data inline, base64ed", formalDefinition="The actual data of the attachment - a sequence of bytes. In XML, represented using base64")
    private Base64BinaryDt myData;
    @Child(name="url", type={UriDt.class}, order=3, min=0, max=1)
    @Description(shortDefinition="Uri where the data can be found", formalDefinition="An alternative location where the data can be accessed")
    private UriDt myUrl;
    @Child(name="size", type={IntegerDt.class}, order=4, min=0, max=1)
    @Description(shortDefinition="Number of bytes of content (if url provided)", formalDefinition="The number of bytes of data that make up this attachment.")
    private IntegerDt mySize;
    @Child(name="hash", type={Base64BinaryDt.class}, order=5, min=0, max=1)
    @Description(shortDefinition="Hash of the data (sha-1, base64ed )", formalDefinition="The calculated hash of the data using SHA-1. Represented using base64")
    private Base64BinaryDt myHash;
    @Child(name="title", type={StringDt.class}, order=6, min=0, max=1)
    @Description(shortDefinition="Label to display in place of the data", formalDefinition="A label or set of text to display in place of the data")
    private StringDt myTitle;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myContentType, this.myLanguage, this.myData, this.myUrl, this.mySize, this.myHash, this.myTitle});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myContentType, this.myLanguage, this.myData, this.myUrl, this.mySize, this.myHash, this.myTitle});
    }

    public CodeDt getContentType() {
        if (this.myContentType == null) {
            this.myContentType = new CodeDt();
        }
        return this.myContentType;
    }

    public CodeDt getContentTypeElement() {
        if (this.myContentType == null) {
            this.myContentType = new CodeDt();
        }
        return this.myContentType;
    }

    public AttachmentDt setContentType(CodeDt theValue) {
        this.myContentType = theValue;
        return this;
    }

    public AttachmentDt setContentType(String theCode) {
        this.myContentType = new CodeDt(theCode);
        return this;
    }

    public CodeDt getLanguage() {
        if (this.myLanguage == null) {
            this.myLanguage = new CodeDt();
        }
        return this.myLanguage;
    }

    public CodeDt getLanguageElement() {
        if (this.myLanguage == null) {
            this.myLanguage = new CodeDt();
        }
        return this.myLanguage;
    }

    public AttachmentDt setLanguage(CodeDt theValue) {
        this.myLanguage = theValue;
        return this;
    }

    public AttachmentDt setLanguage(String theCode) {
        this.myLanguage = new CodeDt(theCode);
        return this;
    }

    public Base64BinaryDt getData() {
        if (this.myData == null) {
            this.myData = new Base64BinaryDt();
        }
        return this.myData;
    }

    public Base64BinaryDt getDataElement() {
        if (this.myData == null) {
            this.myData = new Base64BinaryDt();
        }
        return this.myData;
    }

    public AttachmentDt setData(Base64BinaryDt theValue) {
        this.myData = theValue;
        return this;
    }

    public AttachmentDt setData(byte[] theBytes) {
        this.myData = new Base64BinaryDt(theBytes);
        return this;
    }

    public UriDt getUrl() {
        if (this.myUrl == null) {
            this.myUrl = new UriDt();
        }
        return this.myUrl;
    }

    public UriDt getUrlElement() {
        if (this.myUrl == null) {
            this.myUrl = new UriDt();
        }
        return this.myUrl;
    }

    public AttachmentDt setUrl(UriDt theValue) {
        this.myUrl = theValue;
        return this;
    }

    public AttachmentDt setUrl(String theUri) {
        this.myUrl = new UriDt(theUri);
        return this;
    }

    public IntegerDt getSize() {
        if (this.mySize == null) {
            this.mySize = new IntegerDt();
        }
        return this.mySize;
    }

    public IntegerDt getSizeElement() {
        if (this.mySize == null) {
            this.mySize = new IntegerDt();
        }
        return this.mySize;
    }

    public AttachmentDt setSize(IntegerDt theValue) {
        this.mySize = theValue;
        return this;
    }

    public AttachmentDt setSize(int theInteger) {
        this.mySize = new IntegerDt(theInteger);
        return this;
    }

    public Base64BinaryDt getHash() {
        if (this.myHash == null) {
            this.myHash = new Base64BinaryDt();
        }
        return this.myHash;
    }

    public Base64BinaryDt getHashElement() {
        if (this.myHash == null) {
            this.myHash = new Base64BinaryDt();
        }
        return this.myHash;
    }

    public AttachmentDt setHash(Base64BinaryDt theValue) {
        this.myHash = theValue;
        return this;
    }

    public AttachmentDt setHash(byte[] theBytes) {
        this.myHash = new Base64BinaryDt(theBytes);
        return this;
    }

    public StringDt getTitle() {
        if (this.myTitle == null) {
            this.myTitle = new StringDt();
        }
        return this.myTitle;
    }

    public StringDt getTitleElement() {
        if (this.myTitle == null) {
            this.myTitle = new StringDt();
        }
        return this.myTitle;
    }

    public AttachmentDt setTitle(StringDt theValue) {
        this.myTitle = theValue;
        return this;
    }

    public AttachmentDt setTitle(String theString) {
        this.myTitle = new StringDt(theString);
        return this;
    }
}

