/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.migrate.taskdef;

import ca.uhn.fhir.jpa.migrate.DriverTypeEnum;
import ca.uhn.fhir.jpa.migrate.JdbcUtils;
import ca.uhn.fhir.jpa.migrate.taskdef.BaseTableTask;
import ca.uhn.fhir.jpa.migrate.taskdef.BaseTask;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.RowMapperResultSetExtractor;
import org.springframework.jdbc.core.SingleColumnRowMapper;

public class DropIndexTask
extends BaseTableTask {
    private static final Logger ourLog = LoggerFactory.getLogger(DropIndexTask.class);
    private String myIndexName;

    public DropIndexTask(String theProductVersion, String theSchemaVersion) {
        super(theProductVersion, theSchemaVersion);
    }

    static List<String> createDropIndexSql(DriverTypeEnum.ConnectionProperties theConnectionProperties, String theTableName, String theIndexName, DriverTypeEnum theDriverType) throws SQLException {
        Validate.notBlank((CharSequence)theIndexName, (String)"theIndexName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)theTableName, (String)"theTableName must not be blank", (Object[])new Object[0]);
        if (!JdbcUtils.getIndexNames(theConnectionProperties, theTableName).contains(theIndexName)) {
            return Collections.emptyList();
        }
        boolean isUnique = JdbcUtils.isIndexUnique(theConnectionProperties, theTableName, theIndexName);
        ArrayList<String> sql = new ArrayList<String>();
        if (isUnique) {
            switch (theDriverType) {
                case MYSQL_5_7: 
                case MARIADB_10_1: {
                    sql.add("alter table " + theTableName + " drop index `" + theIndexName + "`");
                    break;
                }
                case H2_EMBEDDED: {
                    sql.add("drop index " + theIndexName);
                    break;
                }
                case DERBY_EMBEDDED: {
                    sql.add("alter table " + theTableName + " drop constraint " + theIndexName);
                    break;
                }
                case ORACLE_12C: {
                    sql.add("drop index " + theIndexName);
                    break;
                }
                case MSSQL_2012: {
                    sql.add("drop index " + theIndexName + " on " + theTableName);
                    break;
                }
                case POSTGRES_9_4: {
                    sql.add("alter table " + theTableName + " drop constraint if exists " + theIndexName + " cascade");
                    sql.add("drop index if exists " + theIndexName + " cascade");
                }
            }
        } else {
            switch (theDriverType) {
                case MYSQL_5_7: 
                case MARIADB_10_1: {
                    sql.add("alter table " + theTableName + " drop index " + theIndexName);
                    break;
                }
                case H2_EMBEDDED: 
                case DERBY_EMBEDDED: 
                case ORACLE_12C: 
                case POSTGRES_9_4: {
                    sql.add("drop index " + theIndexName);
                    break;
                }
                case MSSQL_2012: {
                    sql.add("drop index " + theTableName + "." + theIndexName);
                }
            }
        }
        return sql;
    }

    @Override
    public void validate() {
        super.validate();
        Validate.notBlank((CharSequence)this.myIndexName, (String)"The index name must not be blank", (Object[])new Object[0]);
        this.setDescription("Drop index " + this.myIndexName + " from table " + this.getTableName());
    }

    @Override
    public void doExecute() throws SQLException {
        String dropConstraintSql;
        String findConstraintSql;
        if (this.getDriverType() == DriverTypeEnum.H2_EMBEDDED) {
            findConstraintSql = "SELECT DISTINCT constraint_name FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE constraint_name = ? AND table_name = ?";
            dropConstraintSql = "ALTER TABLE " + this.getTableName() + " DROP CONSTRAINT ?";
            this.findAndDropConstraint(findConstraintSql, dropConstraintSql);
        } else if (this.getDriverType() == DriverTypeEnum.DERBY_EMBEDDED) {
            findConstraintSql = "SELECT c.constraintname FROM sys.sysconstraints c, sys.systables t WHERE c.tableid = t.tableid AND c.constraintname = ? AND t.tablename = ?";
            dropConstraintSql = "ALTER TABLE " + this.getTableName() + " DROP CONSTRAINT ?";
            this.findAndDropConstraint(findConstraintSql, dropConstraintSql);
        } else if (this.getDriverType() == DriverTypeEnum.ORACLE_12C) {
            findConstraintSql = "SELECT DISTINCT constraint_name FROM user_cons_columns WHERE constraint_name = ? AND table_name = ?";
            dropConstraintSql = "ALTER TABLE " + this.getTableName() + " DROP CONSTRAINT ?";
            this.findAndDropConstraint(findConstraintSql, dropConstraintSql);
            findConstraintSql = "SELECT DISTINCT constraint_name FROM all_constraints WHERE index_name = ? AND table_name = ?";
            this.findAndDropConstraint(findConstraintSql, dropConstraintSql);
        } else if (this.getDriverType() == DriverTypeEnum.MSSQL_2012) {
            findConstraintSql = "SELECT tc.CONSTRAINT_NAME FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS AS tc WHERE tc.CONSTRAINT_NAME = ? AND tc.TABLE_NAME = ?";
            dropConstraintSql = "ALTER TABLE " + this.getTableName() + " DROP CONSTRAINT ?";
            this.findAndDropConstraint(findConstraintSql, dropConstraintSql);
        }
        Set<String> indexNames = JdbcUtils.getIndexNames(this.getConnectionProperties(), this.getTableName());
        if (!indexNames.contains(this.myIndexName)) {
            this.logInfo(ourLog, "Index {} does not exist on table {} - No action needed", this.myIndexName, this.getTableName());
            return;
        }
        boolean isUnique = JdbcUtils.isIndexUnique(this.getConnectionProperties(), this.getTableName(), this.myIndexName);
        String uniquenessString = isUnique ? "unique" : "non-unique";
        List<String> sqls = DropIndexTask.createDropIndexSql(this.getConnectionProperties(), this.getTableName(), this.myIndexName, this.getDriverType());
        if (!sqls.isEmpty()) {
            this.logInfo(ourLog, "Dropping {} index {} on table {}", uniquenessString, this.myIndexName, this.getTableName());
        }
        for (String sql : sqls) {
            this.executeSql(this.getTableName(), sql, new Object[0]);
        }
    }

    public void findAndDropConstraint(String theFindConstraintSql, String theDropConstraintSql) {
        DataSource dataSource = Objects.requireNonNull(this.getConnectionProperties().getDataSource());
        this.getConnectionProperties().getTxTemplate().executeWithoutResult(t -> {
            JdbcTemplate jdbcTemplate = new JdbcTemplate(dataSource);
            RowMapperResultSetExtractor resultSetExtractor = new RowMapperResultSetExtractor((RowMapper)new SingleColumnRowMapper(String.class));
            List outcome = (List)jdbcTemplate.query(theFindConstraintSql, new Object[]{this.myIndexName, this.getTableName()}, (ResultSetExtractor)resultSetExtractor);
            assert (outcome != null);
            for (String next : outcome) {
                String sql = theDropConstraintSql.replace("?", next);
                this.executeSql(this.getTableName(), sql, new Object[0]);
            }
        });
    }

    public DropIndexTask setIndexName(String theIndexName) {
        this.myIndexName = theIndexName;
        return this;
    }

    @Override
    protected void generateEquals(EqualsBuilder theBuilder, BaseTask theOtherObject) {
        DropIndexTask otherObject = (DropIndexTask)theOtherObject;
        super.generateEquals(theBuilder, otherObject);
        theBuilder.append((Object)this.myIndexName, (Object)otherObject.myIndexName);
    }

    @Override
    protected void generateHashCode(HashCodeBuilder theBuilder) {
        super.generateHashCode(theBuilder);
        theBuilder.append((Object)this.myIndexName);
    }
}

