/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.migrate.taskdef;

import ca.uhn.fhir.jpa.migrate.taskdef.BaseTask;
import ca.uhn.fhir.jpa.migrate.taskdef.ColumnTypeEnum;
import ca.uhn.fhir.jpa.migrate.taskdef.ColumnTypeToDriverTypeToSqlType;
import java.util.Objects;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public abstract class BaseTableTask
extends BaseTask {
    protected final ColumnTypeToDriverTypeToSqlType myColumnTypeToDriverTypeToSqlType = new ColumnTypeToDriverTypeToSqlType();
    private String myTableName;

    public BaseTableTask(String theProductVersion, String theSchemaVersion) {
        super(theProductVersion, theSchemaVersion);
    }

    public String getTableName() {
        return this.myTableName;
    }

    public BaseTableTask setTableName(String theTableName) {
        Validate.notBlank((CharSequence)theTableName);
        this.myTableName = theTableName;
        return this;
    }

    @Override
    public void validate() {
        Validate.notBlank((CharSequence)this.myTableName);
    }

    @Override
    protected void generateEquals(EqualsBuilder theBuilder, BaseTask theOtherObject) {
        BaseTableTask otherObject = (BaseTableTask)theOtherObject;
        theBuilder.append((Object)this.myTableName, (Object)otherObject.myTableName);
    }

    protected String getSqlType(ColumnTypeEnum theColumnType, Long theColumnLength) {
        String retVal = this.myColumnTypeToDriverTypeToSqlType.getColumnTypeToDriverTypeToSqlType().get((Object)theColumnType).get((Object)this.getDriverType());
        Objects.requireNonNull(retVal);
        if (theColumnType == ColumnTypeEnum.STRING) {
            retVal = retVal.replace("?", Long.toString(theColumnLength));
        }
        return retVal;
    }

    @Override
    protected void generateHashCode(HashCodeBuilder theBuilder) {
        theBuilder.append((Object)this.myTableName);
    }
}

