/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.migrate.taskdef;

import ca.uhn.fhir.jpa.migrate.JdbcUtils;
import ca.uhn.fhir.jpa.migrate.taskdef.BaseTask;
import ca.uhn.fhir.util.VersionEnum;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.ColumnMapRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class ArbitrarySqlTask
extends BaseTask {
    private static final Logger ourLog = LoggerFactory.getLogger(ArbitrarySqlTask.class);
    private final String myDescription;
    private final String myTableName;
    private List<Task> myTask = new ArrayList<Task>();
    private int myBatchSize = 1000;
    private String myExecuteOnlyIfTableExists;
    private List<TableAndColumn> myConditionalOnExistenceOf = new ArrayList<TableAndColumn>();

    public ArbitrarySqlTask(VersionEnum theRelease, String theVersion, String theTableName, String theDescription) {
        super(theRelease.toString(), theVersion);
        this.myTableName = theTableName;
        this.myDescription = theDescription;
    }

    public void addQuery(String theSql, QueryModeEnum theMode, Consumer<Map<String, Object>> theConsumer) {
        this.myTask.add(new QueryTask(theSql, theMode, theConsumer));
    }

    @Override
    public void validate() {
    }

    @Override
    public void doExecute() throws SQLException {
        Set<String> tableNames;
        this.logInfo(ourLog, "Starting: {}", this.myDescription);
        if (StringUtils.isNotBlank((CharSequence)this.myExecuteOnlyIfTableExists) && !(tableNames = JdbcUtils.getTableNames(this.getConnectionProperties())).contains(this.myExecuteOnlyIfTableExists.toUpperCase())) {
            this.logInfo(ourLog, "Table {} does not exist - No action performed", this.myExecuteOnlyIfTableExists);
            return;
        }
        for (TableAndColumn tableAndColumn : this.myConditionalOnExistenceOf) {
            JdbcUtils.ColumnType columnType = JdbcUtils.getColumnType(this.getConnectionProperties(), tableAndColumn.getTable(), tableAndColumn.getColumn());
            if (columnType != null) continue;
            this.logInfo(ourLog, "Table {} does not have column {} - No action performed", tableAndColumn.getTable(), tableAndColumn.getColumn());
            return;
        }
        for (Task task : this.myTask) {
            task.execute();
        }
    }

    public void setBatchSize(int theBatchSize) {
        this.myBatchSize = theBatchSize;
    }

    public void setExecuteOnlyIfTableExists(String theExecuteOnlyIfTableExists) {
        this.myExecuteOnlyIfTableExists = theExecuteOnlyIfTableExists;
    }

    public void addExecuteOnlyIfColumnExists(String theTableName, String theColumnName) {
        this.myConditionalOnExistenceOf.add(new TableAndColumn(theTableName, theColumnName));
    }

    @Override
    protected void generateEquals(EqualsBuilder theBuilder, BaseTask theOtherObject) {
        ArbitrarySqlTask otherObject = (ArbitrarySqlTask)theOtherObject;
        theBuilder.append((Object)this.myTableName, (Object)otherObject.myTableName);
    }

    @Override
    protected void generateHashCode(HashCodeBuilder theBuilder) {
        theBuilder.append((Object)this.myTableName);
    }

    private class QueryTask
    extends Task {
        private final String mySql;
        private final Consumer<Map<String, Object>> myConsumer;

        public QueryTask(String theSql, QueryModeEnum theMode, Consumer<Map<String, Object>> theConsumer) {
            this.mySql = theSql;
            this.myConsumer = theConsumer;
            ArbitrarySqlTask.this.setDescription("Execute raw sql");
        }

        @Override
        public void execute() {
            List rows;
            if (ArbitrarySqlTask.this.isDryRun()) {
                return;
            }
            do {
                ArbitrarySqlTask.this.logInfo(ourLog, "Querying for up to {} rows", ArbitrarySqlTask.this.myBatchSize);
                rows = (List)ArbitrarySqlTask.this.getTxTemplate().execute(t -> {
                    JdbcTemplate jdbcTemplate = ArbitrarySqlTask.this.newJdbcTemplate();
                    jdbcTemplate.setMaxRows(ArbitrarySqlTask.this.myBatchSize);
                    return jdbcTemplate.query(this.mySql, (RowMapper)new ColumnMapRowMapper());
                });
                ArbitrarySqlTask.this.logInfo(ourLog, "Processing {} rows", rows.size());
                List finalRows = rows;
                ArbitrarySqlTask.this.getTxTemplate().execute(t -> {
                    for (Map nextRow : finalRows) {
                        this.myConsumer.accept(nextRow);
                    }
                    return null;
                });
            } while (rows.size() > 0);
        }
    }

    public static enum QueryModeEnum {
        BATCH_UNTIL_NO_MORE;

    }

    private static class TableAndColumn {
        private final String myTable;
        private final String myColumn;

        private TableAndColumn(String theTable, String theColumn) {
            this.myTable = theTable;
            this.myColumn = theColumn;
        }

        public String getTable() {
            return this.myTable;
        }

        public String getColumn() {
            return this.myColumn;
        }
    }

    private abstract class Task {
        private Task() {
        }

        public abstract void execute();
    }
}

