/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.provider;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.rest.annotation.Operation;
import ca.uhn.fhir.rest.annotation.OperationParam;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.storage.IDeleteExpungeJobSubmitter;
import ca.uhn.fhir.rest.server.provider.MultiUrlProcessor;
import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public class DeleteExpungeProvider {
    private final MultiUrlProcessor myMultiUrlProcessor;

    public DeleteExpungeProvider(FhirContext theFhirContext, IDeleteExpungeJobSubmitter theDeleteExpungeJobSubmitter) {
        this.myMultiUrlProcessor = new MultiUrlProcessor(theFhirContext, theDeleteExpungeJobSubmitter);
    }

    @Operation(name="$delete-expunge", idempotent=false)
    public IBaseParameters deleteExpunge(@OperationParam(name="url", typeName="string", min=1) List<IPrimitiveType<String>> theUrlsToDeleteExpunge, @OperationParam(name="batchSize", typeName="decimal", min=0, max=1) IPrimitiveType<BigDecimal> theBatchSize, RequestDetails theRequestDetails) {
        List<String> urls = theUrlsToDeleteExpunge.stream().map(IPrimitiveType::getValue).collect(Collectors.toList());
        Integer batchSize = this.myMultiUrlProcessor.getBatchSize(theBatchSize);
        return this.myMultiUrlProcessor.processUrls(urls, batchSize, theRequestDetails);
    }
}

