/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.method;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.base.resource.BaseOperationOutcome;
import ca.uhn.fhir.model.valueset.BundleTypeEnum;
import ca.uhn.fhir.rest.annotation.Transaction;
import ca.uhn.fhir.rest.annotation.TransactionParam;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.IRestfulServer;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.interceptor.IServerInterceptor;
import ca.uhn.fhir.rest.server.method.BaseResourceReturningMethodBinding;
import ca.uhn.fhir.rest.server.method.IParameter;
import ca.uhn.fhir.rest.server.method.MethodMatchEnum;
import ca.uhn.fhir.rest.server.method.ResourceParameter;
import ca.uhn.fhir.rest.server.method.TransactionParameter;
import java.lang.reflect.Method;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class TransactionMethodBinding
extends BaseResourceReturningMethodBinding {
    private int myTransactionParamIndex = -1;
    private TransactionParameter.ParamStyle myTransactionParamStyle;

    public TransactionMethodBinding(Method theMethod, FhirContext theContext, Object theProvider) {
        super(null, theMethod, theContext, theProvider);
        int index = 0;
        for (IParameter next : this.getParameters()) {
            if (next instanceof TransactionParameter) {
                if (this.myTransactionParamIndex != -1) {
                    throw new ConfigurationException("Method '" + theMethod.getName() + "' in type " + theMethod.getDeclaringClass().getCanonicalName() + " has multiple parameters annotated with the @" + TransactionParam.class + " annotation, exactly one is required for @" + Transaction.class + " methods");
                }
                this.myTransactionParamIndex = index;
                this.myTransactionParamStyle = ((TransactionParameter)next).getParamStyle();
            }
            ++index;
        }
        if (this.myTransactionParamIndex == -1) {
            throw new ConfigurationException("Method '" + theMethod.getName() + "' in type " + theMethod.getDeclaringClass().getCanonicalName() + " does not have a parameter annotated with the @" + TransactionParam.class + " annotation");
        }
    }

    @Override
    @Nonnull
    public RestOperationTypeEnum getRestOperationType() {
        return RestOperationTypeEnum.TRANSACTION;
    }

    @Override
    protected BundleTypeEnum getResponseBundleType() {
        return BundleTypeEnum.TRANSACTION_RESPONSE;
    }

    @Override
    public BaseResourceReturningMethodBinding.ReturnTypeEnum getReturnType() {
        return BaseResourceReturningMethodBinding.ReturnTypeEnum.BUNDLE;
    }

    @Override
    public MethodMatchEnum incomingServerRequestMatchesMethod(RequestDetails theRequest) {
        if (theRequest.getRequestType() != RequestTypeEnum.POST) {
            return MethodMatchEnum.NONE;
        }
        if (StringUtils.isNotBlank((CharSequence)theRequest.getOperation())) {
            return MethodMatchEnum.NONE;
        }
        if (StringUtils.isNotBlank((CharSequence)theRequest.getResourceName())) {
            return MethodMatchEnum.NONE;
        }
        return MethodMatchEnum.EXACT;
    }

    @Override
    public Object invokeServer(IRestfulServer<?> theServer, RequestDetails theRequest, Object[] theMethodParams) throws InvalidRequestException, InternalErrorException {
        if (this.myTransactionParamStyle == TransactionParameter.ParamStyle.RESOURCE_BUNDLE) {
            Object response = this.invokeServerMethod(theRequest, theMethodParams);
            return response;
        }
        Object response = this.invokeServerMethod(theRequest, theMethodParams);
        IBundleProvider retVal = this.toResourceList(response);
        List<IBaseResource> retResources = retVal.getAllResources();
        for (int i = 0; i < retResources.size(); ++i) {
            IBaseResource newRes = retResources.get(i);
            if (newRes.getIdElement() != null && !newRes.getIdElement().isEmpty() || newRes instanceof BaseOperationOutcome) continue;
            throw new InternalErrorException("Transaction method returned resource at index " + i + " with no id specified - IResource#setId(IdDt)");
        }
        return retVal;
    }

    @Override
    protected void populateActionRequestDetailsForInterceptor(RequestDetails theRequestDetails, IServerInterceptor.ActionRequestDetails theDetails, Object[] theMethodParams) {
        IBaseResource resource;
        super.populateActionRequestDetailsForInterceptor(theRequestDetails, theDetails, theMethodParams);
        if (this.myTransactionParamIndex != -1) {
            resource = (IBaseResource)theMethodParams[this.myTransactionParamIndex];
        } else {
            Class resourceType = this.getContext().getResourceDefinition("Bundle").getImplementingClass();
            resource = ResourceParameter.parseResourceFromRequest(theRequestDetails, this, resourceType);
        }
        theRequestDetails.setResource(resource);
        if (theDetails != null) {
            theDetails.setResource(resource);
        }
    }
}

