/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.method;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IPointcut;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.model.valueset.BundleTypeEnum;
import ca.uhn.fhir.rest.annotation.Metadata;
import ca.uhn.fhir.rest.api.CacheControlDirective;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.IRestfulServer;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.RestfulServer;
import ca.uhn.fhir.rest.server.SimpleBundleProvider;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.rest.server.exceptions.MethodNotAllowedException;
import ca.uhn.fhir.rest.server.interceptor.IServerInterceptor;
import ca.uhn.fhir.rest.server.method.BaseResourceReturningMethodBinding;
import ca.uhn.fhir.rest.server.method.MethodMatchEnum;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import java.lang.reflect.Method;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import org.hl7.fhir.instance.model.api.IBaseConformance;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class ConformanceMethodBinding
extends BaseResourceReturningMethodBinding {
    public static final String CACHE_THREAD_PREFIX = "capabilitystatement-cache-";
    private final AtomicReference<IBaseConformance> myCachedResponse = new AtomicReference();
    private final AtomicLong myCachedResponseExpires = new AtomicLong(0L);
    private final ExecutorService myThreadPool;
    private long myCacheMillis = 60000L;

    ConformanceMethodBinding(Method theMethod, FhirContext theContext, Object theProvider) {
        super(theMethod.getReturnType(), theMethod, theContext, theProvider);
        BaseResourceReturningMethodBinding.MethodReturnTypeEnum methodReturnType = this.getMethodReturnType();
        Class genericReturnType = (Class)theMethod.getGenericReturnType();
        if (methodReturnType != BaseResourceReturningMethodBinding.MethodReturnTypeEnum.RESOURCE || !IBaseConformance.class.isAssignableFrom(genericReturnType)) {
            throw new ConfigurationException("Conformance resource provider method '" + theMethod.getName() + "' should return a Conformance resource class, returns: " + theMethod.getReturnType());
        }
        Metadata metadata = theMethod.getAnnotation(Metadata.class);
        if (metadata != null) {
            this.setCacheMillis(metadata.cacheMillis());
        }
        ThreadFactory threadFactory = r -> {
            Thread t = new Thread(r);
            t.setName(CACHE_THREAD_PREFIX + t.getId());
            t.setDaemon(false);
            return t;
        };
        this.myThreadPool = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(1), threadFactory, new ThreadPoolExecutor.DiscardOldestPolicy());
    }

    private long getCacheMillis() {
        return this.myCacheMillis;
    }

    public void setCacheMillis(long theCacheMillis) {
        this.myCacheMillis = theCacheMillis;
    }

    @Override
    public BaseResourceReturningMethodBinding.ReturnTypeEnum getReturnType() {
        return BaseResourceReturningMethodBinding.ReturnTypeEnum.RESOURCE;
    }

    @Override
    public void close() {
        super.close();
        this.myThreadPool.shutdown();
    }

    @Override
    public IBundleProvider invokeServer(IRestfulServer<?> theServer, RequestDetails theRequest, Object[] theMethodParams) throws BaseServerResponseException {
        RestOperationTypeEnum operationType;
        IBaseConformance conf;
        CacheControlDirective cacheControlDirective = new CacheControlDirective().parse(theRequest.getHeaders("Cache-Control"));
        if (cacheControlDirective.isNoCache()) {
            conf = null;
        } else {
            long expires;
            conf = this.myCachedResponse.get();
            if ("true".equals(System.getProperty("test"))) {
                conf = null;
            }
            if (conf != null && (expires = this.myCachedResponseExpires.get()) < System.currentTimeMillis()) {
                this.myCachedResponseExpires.set(System.currentTimeMillis() + this.getCacheMillis());
                this.myThreadPool.submit(() -> this.createCapabilityStatement(theRequest, theMethodParams));
            }
        }
        if (conf != null && (operationType = this.getRestOperationType(theRequest)) != null) {
            IServerInterceptor.ActionRequestDetails details = new IServerInterceptor.ActionRequestDetails(theRequest);
            this.populateActionRequestDetailsForInterceptor(theRequest, details, theMethodParams);
            if (theRequest.getInterceptorBroadcaster() != null) {
                HookParams preHandledParams = new HookParams();
                preHandledParams.add(RestOperationTypeEnum.class, (Object)theRequest.getRestOperationType());
                preHandledParams.add(RequestDetails.class, (Object)theRequest);
                preHandledParams.addIfMatchesType(ServletRequestDetails.class, (Object)theRequest);
                preHandledParams.add(IServerInterceptor.ActionRequestDetails.class, (Object)details);
                theRequest.getInterceptorBroadcaster().callHooks((IPointcut)Pointcut.SERVER_INCOMING_REQUEST_PRE_HANDLED, preHandledParams);
            }
        }
        if (conf == null) {
            conf = this.createCapabilityStatement(theRequest, theMethodParams);
        }
        return new SimpleBundleProvider((IBaseResource)conf);
    }

    private IBaseConformance createCapabilityStatement(RequestDetails theRequest, Object[] theMethodParams) {
        IBaseConformance conf = (IBaseConformance)this.invokeServerMethod(theRequest, theMethodParams);
        if (theRequest.getInterceptorBroadcaster() != null) {
            HookParams params = new HookParams();
            params.add(IBaseConformance.class, (Object)conf);
            params.add(RequestDetails.class, (Object)theRequest);
            params.addIfMatchesType(ServletRequestDetails.class, (Object)theRequest);
            IBaseConformance outcome = (IBaseConformance)theRequest.getInterceptorBroadcaster().callHooksAndReturnObject((IPointcut)Pointcut.SERVER_CAPABILITY_STATEMENT_GENERATED, params);
            if (outcome != null) {
                conf = outcome;
            }
        }
        if (this.myCacheMillis > 0L) {
            this.myCachedResponse.set(conf);
            this.myCachedResponseExpires.set(System.currentTimeMillis() + this.getCacheMillis());
        }
        return conf;
    }

    @Override
    public MethodMatchEnum incomingServerRequestMatchesMethod(RequestDetails theRequest) {
        if (theRequest.getRequestType() == RequestTypeEnum.OPTIONS && theRequest.getOperation() == null && theRequest.getResourceName() == null) {
            return MethodMatchEnum.EXACT;
        }
        if (theRequest.getResourceName() != null) {
            return MethodMatchEnum.NONE;
        }
        if ("metadata".equals(theRequest.getOperation())) {
            if (theRequest.getRequestType() == RequestTypeEnum.GET) {
                return MethodMatchEnum.EXACT;
            }
            throw new MethodNotAllowedException("/metadata request must use HTTP GET", new RequestTypeEnum[]{RequestTypeEnum.GET});
        }
        return MethodMatchEnum.NONE;
    }

    @Override
    @Nonnull
    public RestOperationTypeEnum getRestOperationType() {
        return RestOperationTypeEnum.METADATA;
    }

    @Override
    protected BundleTypeEnum getResponseBundleType() {
        return null;
    }

    public IBaseConformance provideCapabilityStatement(RestfulServer theServer, RequestDetails theRequest) {
        Object[] params = this.createMethodParams(theRequest);
        Object resultObj = this.invokeServer((IRestfulServer)theServer, theRequest, params);
        return (IBaseConformance)resultObj.getResources(0, 1).get(0);
    }
}

