/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor.auth;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.rest.api.QualifiedParamList;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import ca.uhn.fhir.rest.server.interceptor.auth.AdditionalCompartmentSearchParameters;
import ca.uhn.fhir.rest.server.interceptor.auth.AppliesTypeEnum;
import ca.uhn.fhir.rest.server.interceptor.auth.AuthorizationFlagsEnum;
import ca.uhn.fhir.rest.server.interceptor.auth.AuthorizationInterceptor;
import ca.uhn.fhir.rest.server.interceptor.auth.BaseRule;
import ca.uhn.fhir.rest.server.interceptor.auth.ClassifierTypeEnum;
import ca.uhn.fhir.rest.server.interceptor.auth.IRuleApplier;
import ca.uhn.fhir.rest.server.interceptor.auth.PolicyEnum;
import ca.uhn.fhir.rest.server.interceptor.auth.RuleOpEnum;
import ca.uhn.fhir.rest.server.interceptor.auth.RuleTarget;
import ca.uhn.fhir.rest.server.interceptor.auth.TransactionAppliesToEnum;
import ca.uhn.fhir.util.BundleUtil;
import ca.uhn.fhir.util.FhirTerser;
import ca.uhn.fhir.util.UrlUtil;
import ca.uhn.fhir.util.bundle.BundleEntryParts;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;

class RuleImplOp
extends BaseRule {
    private AppliesTypeEnum myAppliesTo;
    private Set<String> myAppliesToTypes;
    private String myClassifierCompartmentName;
    private Collection<? extends IIdType> myClassifierCompartmentOwners;
    private ClassifierTypeEnum myClassifierType;
    private RuleOpEnum myOp;
    private TransactionAppliesToEnum myTransactionAppliesToOp;
    private Collection<IIdType> myAppliesToInstances;
    private boolean myAppliesToDeleteCascade;
    private boolean myAppliesToDeleteExpunge;
    private AdditionalCompartmentSearchParameters myAdditionalCompartmentSearchParamMap;

    RuleImplOp(String theRuleName) {
        super(theRuleName);
    }

    @VisibleForTesting
    Collection<IIdType> getAppliesToInstances() {
        return this.myAppliesToInstances;
    }

    void setAppliesToInstances(Collection<IIdType> theAppliesToInstances) {
        this.myAppliesToInstances = theAppliesToInstances;
    }

    @Override
    public AuthorizationInterceptor.Verdict applyRule(RestOperationTypeEnum theOperation, RequestDetails theRequestDetails, IBaseResource theInputResource, IIdType theInputResourceId, IBaseResource theOutputResource, IRuleApplier theRuleApplier, Set<AuthorizationFlagsEnum> theFlags, Pointcut thePointcut) {
        FhirContext ctx = theRequestDetails.getServer().getFhirContext();
        RuleTarget target = new RuleTarget();
        block0 : switch (this.myOp) {
            case READ: {
                if (theOutputResource == null) {
                    switch (theOperation) {
                        case READ: 
                        case VREAD: {
                            target.resourceIds = Collections.singleton(theInputResourceId);
                            target.resourceType = theInputResourceId.getResourceType();
                            break;
                        }
                        case SEARCH_SYSTEM: 
                        case HISTORY_SYSTEM: {
                            if (!theFlags.contains((Object)AuthorizationFlagsEnum.NO_NOT_PROACTIVELY_BLOCK_COMPARTMENT_READ_ACCESS)) break;
                            return this.newVerdict(theOperation, theRequestDetails, theInputResource, theInputResourceId, theOutputResource);
                        }
                        case SEARCH_TYPE: {
                            if (theFlags.contains((Object)AuthorizationFlagsEnum.NO_NOT_PROACTIVELY_BLOCK_COMPARTMENT_READ_ACCESS)) {
                                return this.newVerdict(theOperation, theRequestDetails, theInputResource, theInputResourceId, theOutputResource);
                            }
                            target.resourceType = theRequestDetails.getResourceName();
                            target.setSearchParams(theRequestDetails);
                            if (!theRequestDetails.getParameters().containsKey("_id")) break;
                            this.setTargetFromResourceId(theRequestDetails, ctx, target);
                            break;
                        }
                        case HISTORY_TYPE: {
                            if (theFlags.contains((Object)AuthorizationFlagsEnum.NO_NOT_PROACTIVELY_BLOCK_COMPARTMENT_READ_ACCESS)) {
                                return this.newVerdict(theOperation, theRequestDetails, theInputResource, theInputResourceId, theOutputResource);
                            }
                            target.resourceType = theRequestDetails.getResourceName();
                            break;
                        }
                        case HISTORY_INSTANCE: {
                            if (theFlags.contains((Object)AuthorizationFlagsEnum.NO_NOT_PROACTIVELY_BLOCK_COMPARTMENT_READ_ACCESS)) {
                                return this.newVerdict(theOperation, theRequestDetails, theInputResource, theInputResourceId, theOutputResource);
                            }
                            target.resourceIds = Collections.singleton(theInputResourceId);
                            break;
                        }
                        case GET_PAGE: {
                            return this.newVerdict(theOperation, theRequestDetails, theInputResource, theInputResourceId, theOutputResource);
                        }
                        default: {
                            return null;
                        }
                    }
                }
                target.resource = theOutputResource;
                if (theOutputResource == null) break;
                target.resourceIds = Collections.singleton(theOutputResource.getIdElement());
                break;
            }
            case WRITE: {
                if (theInputResource == null && theInputResourceId == null) {
                    return null;
                }
                switch (theOperation) {
                    case ADD_TAGS: 
                    case DELETE_TAGS: 
                    case CREATE: 
                    case UPDATE: 
                    case META_ADD: 
                    case META_DELETE: {
                        target.resource = theInputResource;
                        if (theInputResourceId == null) break block0;
                        target.resourceIds = Collections.singletonList(theInputResourceId);
                        break block0;
                    }
                    case PATCH: {
                        target.resource = null;
                        if (theInputResourceId != null) {
                            target.resourceIds = Collections.singletonList(theInputResourceId);
                            break block0;
                        }
                        return null;
                    }
                    default: {
                        return null;
                    }
                }
            }
            case CREATE: {
                if (theInputResource == null && theInputResourceId == null) {
                    return null;
                }
                if (theOperation == RestOperationTypeEnum.CREATE) {
                    target.resource = theInputResource;
                    if (theInputResourceId == null) break;
                    target.resourceIds = Collections.singletonList(theInputResourceId);
                    break;
                }
                return null;
            }
            case DELETE: {
                if (theOperation == RestOperationTypeEnum.DELETE) {
                    if (thePointcut == Pointcut.STORAGE_PRE_DELETE_EXPUNGE && this.myAppliesToDeleteExpunge) {
                        return this.newVerdict(theOperation, theRequestDetails, theInputResource, theInputResourceId, theOutputResource);
                    }
                    if (this.myAppliesToDeleteCascade != (thePointcut == Pointcut.STORAGE_CASCADE_DELETE)) {
                        return null;
                    }
                    if (theInputResourceId == null) {
                        return null;
                    }
                    if (!theInputResourceId.hasIdPart()) {
                        return this.newVerdict(theOperation, theRequestDetails, theInputResource, theInputResourceId, theOutputResource);
                    }
                    if (theInputResource == null && this.myClassifierCompartmentOwners != null && this.myClassifierCompartmentOwners.size() > 0) {
                        return this.newVerdict(theOperation, theRequestDetails, theInputResource, theInputResourceId, theOutputResource);
                    }
                    target.resource = theInputResource;
                    target.resourceIds = Collections.singleton(theInputResourceId);
                    break;
                }
                return null;
            }
            case GRAPHQL: {
                return this.applyRuleToGraphQl(theOperation, theRequestDetails, theInputResource, theInputResourceId, theOutputResource, thePointcut);
            }
            case TRANSACTION: {
                return this.applyRuleToTransaction(theOperation, theRequestDetails, theInputResource, theInputResourceId, theOutputResource, theRuleApplier, thePointcut, ctx);
            }
            case ALL: {
                return this.newVerdict(theOperation, theRequestDetails, theInputResource, theInputResourceId, theOutputResource);
            }
            case METADATA: {
                if (theOperation == RestOperationTypeEnum.METADATA) {
                    return this.newVerdict(theOperation, theRequestDetails, theInputResource, theInputResourceId, theOutputResource);
                }
                return null;
            }
            default: {
                throw new IllegalStateException("Unable to apply security to event of type " + theOperation);
            }
        }
        switch (this.myAppliesTo) {
            case INSTANCES: {
                return this.applyRuleToInstances(theOperation, theRequestDetails, theInputResource, theInputResourceId, theOutputResource, target);
            }
            case ALL_RESOURCES: {
                if (target.resourceType == null || this.myClassifierType != ClassifierTypeEnum.ANY_ID) break;
                return this.newVerdict(theOperation, theRequestDetails, theInputResource, theInputResourceId, theOutputResource);
            }
            case TYPES: {
                String type;
                if (target.resource != null && this.myClassifierType == ClassifierTypeEnum.ANY_ID && !this.myAppliesToTypes.contains(type = theRequestDetails.getFhirContext().getResourceType(target.resource))) {
                    return null;
                }
                if (target.resourceIds != null) {
                    for (IIdType nextRequestAppliesToResourceId : target.resourceIds) {
                        String nextRequestAppliesToResourceIdType;
                        if (!nextRequestAppliesToResourceId.hasResourceType() || this.myAppliesToTypes.contains(nextRequestAppliesToResourceIdType = nextRequestAppliesToResourceId.getResourceType())) continue;
                        return null;
                    }
                }
                if (target.resourceType == null) break;
                if (!this.myAppliesToTypes.contains(target.resourceType)) {
                    return null;
                }
                if (this.myClassifierType == ClassifierTypeEnum.ANY_ID) {
                    return this.newVerdict(theOperation, theRequestDetails, theInputResource, theInputResourceId, theOutputResource);
                }
                if (this.myClassifierType != ClassifierTypeEnum.IN_COMPARTMENT) break;
                break;
            }
            default: {
                throw new IllegalStateException("Unable to apply security to event of applies to type " + (Object)((Object)this.myAppliesTo));
            }
        }
        switch (this.myClassifierType) {
            case ANY_ID: {
                break;
            }
            case IN_COMPARTMENT: {
                return this.applyRuleToCompartment(theOperation, theRequestDetails, theInputResource, theInputResourceId, theOutputResource, theFlags, ctx, target);
            }
            default: {
                throw new IllegalStateException("Unable to apply security to event of applies to type " + (Object)((Object)this.myAppliesTo));
            }
        }
        return this.newVerdict(theOperation, theRequestDetails, theInputResource, theInputResourceId, theOutputResource);
    }

    @Nullable
    private AuthorizationInterceptor.Verdict applyRuleToGraphQl(RestOperationTypeEnum theOperation, RequestDetails theRequestDetails, IBaseResource theInputResource, IIdType theInputResourceId, IBaseResource theOutputResource, Pointcut thePointcut) {
        if (theOperation == RestOperationTypeEnum.GRAPHQL_REQUEST) {
            if (this.isResourceAccess(thePointcut)) {
                return null;
            }
            return this.newVerdict(theOperation, theRequestDetails, theInputResource, theInputResourceId, theOutputResource);
        }
        return null;
    }

    @Nullable
    private AuthorizationInterceptor.Verdict applyRuleToCompartment(RestOperationTypeEnum theOperation, RequestDetails theRequestDetails, IBaseResource theInputResource, IIdType theInputResourceId, IBaseResource theOutputResource, Set<AuthorizationFlagsEnum> theFlags, FhirContext ctx, RuleTarget target) {
        boolean haveOwnersForAll;
        FhirTerser t = ctx.newTerser();
        boolean foundMatch = false;
        if (target.resourceIds != null && target.resourceIds.size() > 0 && (haveOwnersForAll = target.resourceIds.stream().allMatch(n -> this.myClassifierCompartmentOwners.contains(n.toUnqualifiedVersionless())))) {
            foundMatch = true;
        }
        for (IIdType iIdType : this.myClassifierCompartmentOwners) {
            AuthorizationInterceptor.Verdict verdict;
            if (target.resource != null) {
                Set<String> additionalSearchParamNames = null;
                if (this.myAdditionalCompartmentSearchParamMap != null) {
                    additionalSearchParamNames = this.myAdditionalCompartmentSearchParamMap.getSearchParamNamesForResourceType(ctx.getResourceType(target.resource));
                }
                if (t.isSourceInCompartmentForTarget(this.myClassifierCompartmentName, target.resource, iIdType, additionalSearchParamNames)) {
                    foundMatch = true;
                    break;
                }
            }
            if (iIdType.getResourceType().equals(target.resourceType) && (verdict = this.checkForSearchParameterMatchingCompartmentAndReturnSuccessfulVerdictOrNull(target.getSearchParams(), iIdType, "_id", theOperation, theRequestDetails, theInputResource, theInputResourceId, theOutputResource)) != null) {
                return verdict;
            }
            if (!StringUtils.isNotBlank((CharSequence)target.resourceType)) continue;
            RuntimeResourceDefinition sourceDef = theRequestDetails.getFhirContext().getResourceDefinition(target.resourceType);
            String compartmentOwnerResourceType = iIdType.getResourceType();
            if (StringUtils.equals((CharSequence)target.resourceType, (CharSequence)compartmentOwnerResourceType)) continue;
            List params = sourceDef.getSearchParamsForCompartmentName(compartmentOwnerResourceType);
            Set<String> additionalParamNames = this.myAdditionalCompartmentSearchParamMap.getSearchParamNamesForResourceType(sourceDef.getName());
            List additionalParams = additionalParamNames.stream().map(arg_0 -> ((RuntimeResourceDefinition)sourceDef).getSearchParam(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
            if (params == null || params.isEmpty()) {
                params = additionalParams;
            } else {
                params.addAll(additionalParams);
            }
            if (params.isEmpty()) continue;
            if (target.getSearchParams() != null && !theFlags.contains((Object)AuthorizationFlagsEnum.NO_NOT_PROACTIVELY_BLOCK_COMPARTMENT_READ_ACCESS)) {
                for (RuntimeSearchParam nextRuntimeSearchParam : params) {
                    String name = nextRuntimeSearchParam.getName();
                    AuthorizationInterceptor.Verdict verdict2 = this.checkForSearchParameterMatchingCompartmentAndReturnSuccessfulVerdictOrNull(target.getSearchParams(), iIdType, name, theOperation, theRequestDetails, theInputResource, theInputResourceId, theOutputResource);
                    if (verdict2 == null) continue;
                    return verdict2;
                }
                continue;
            }
            if (this.getMode() != PolicyEnum.ALLOW) continue;
            return this.newVerdict(theOperation, theRequestDetails, theInputResource, theInputResourceId, theOutputResource);
        }
        if (!foundMatch) {
            return null;
        }
        return this.newVerdict(theOperation, theRequestDetails, theInputResource, theInputResourceId, theOutputResource);
    }

    @Nullable
    private AuthorizationInterceptor.Verdict applyRuleToInstances(RestOperationTypeEnum theOperation, RequestDetails theRequestDetails, IBaseResource theInputResource, IIdType theInputResourceId, IBaseResource theOutputResource, RuleTarget target) {
        if (target.resourceIds != null && target.resourceIds.size() > 0) {
            int haveMatches = 0;
            block0: for (IIdType requestAppliesToResource : target.resourceIds) {
                for (IIdType next : this.myAppliesToInstances) {
                    if (StringUtils.isNotBlank((CharSequence)next.getResourceType()) && !next.getResourceType().equals(requestAppliesToResource.getResourceType()) || !next.getIdPart().equals(requestAppliesToResource.getIdPart())) continue;
                    ++haveMatches;
                    continue block0;
                }
            }
            if (haveMatches == target.resourceIds.size()) {
                return this.newVerdict(theOperation, theRequestDetails, theInputResource, theInputResourceId, theOutputResource);
            }
        }
        return null;
    }

    @Nullable
    private AuthorizationInterceptor.Verdict applyRuleToTransaction(RestOperationTypeEnum theOperation, RequestDetails theRequestDetails, IBaseResource theInputResource, IIdType theInputResourceId, IBaseResource theOutputResource, IRuleApplier theRuleApplier, Pointcut thePointcut, FhirContext ctx) {
        if (theOperation != RestOperationTypeEnum.TRANSACTION) {
            return null;
        }
        if (theInputResource != null && this.requestAppliesToTransaction(ctx, this.myOp, theInputResource)) {
            if (this.getMode() == PolicyEnum.DENY) {
                return this.newVerdict(theOperation, theRequestDetails, theInputResource, theInputResourceId, theOutputResource);
            }
            List inputResources = BundleUtil.toListOfEntries((FhirContext)ctx, (IBaseBundle)((IBaseBundle)theInputResource));
            AuthorizationInterceptor.Verdict verdict = null;
            boolean allComponentsAreGets = true;
            for (BundleEntryParts nextPart : inputResources) {
                RuntimeResourceDefinition resourceDef;
                RestOperationTypeEnum operation;
                IBaseResource inputResource = nextPart.getResource();
                IIdType inputResourceId = null;
                if (StringUtils.isNotBlank((CharSequence)nextPart.getUrl())) {
                    UrlUtil.UrlParts parts = UrlUtil.parseUrl((String)nextPart.getUrl());
                    inputResourceId = theRequestDetails.getFhirContext().getVersion().newIdType();
                    inputResourceId.setParts(null, parts.getResourceType(), parts.getResourceId(), null);
                }
                if (nextPart.getRequestType() == RequestTypeEnum.GET) continue;
                allComponentsAreGets = false;
                if (nextPart.getRequestType() == RequestTypeEnum.POST) {
                    operation = RestOperationTypeEnum.CREATE;
                } else if (nextPart.getRequestType() == RequestTypeEnum.PUT) {
                    operation = RestOperationTypeEnum.UPDATE;
                } else if (nextPart.getRequestType() == RequestTypeEnum.DELETE) {
                    operation = RestOperationTypeEnum.DELETE;
                } else if (nextPart.getRequestType() == RequestTypeEnum.PATCH) {
                    operation = RestOperationTypeEnum.PATCH;
                } else if (nextPart.getRequestType() == null && theRequestDetails.getServer().getFhirContext().getVersion().getVersion() == FhirVersionEnum.DSTU3 && BundleUtil.isDstu3TransactionPatch((FhirContext)theRequestDetails.getFhirContext(), (IBaseResource)nextPart.getResource())) {
                    operation = RestOperationTypeEnum.PATCH;
                } else {
                    throw new InvalidRequestException("Can not handle transaction with operation of type " + nextPart.getRequestType());
                }
                if (nextPart.getResource() != null && ("Parameters".equals((resourceDef = ctx.getResourceDefinition(nextPart.getResource())).getName()) || "Bundle".equals(resourceDef.getName()))) {
                    throw new InvalidRequestException("Can not handle transaction with nested resource of type " + resourceDef.getName());
                }
                String previousFixedConditionalUrl = theRequestDetails.getFixedConditionalUrl();
                theRequestDetails.setFixedConditionalUrl(nextPart.getConditionalUrl());
                AuthorizationInterceptor.Verdict newVerdict = theRuleApplier.applyRulesAndReturnDecision(operation, theRequestDetails, inputResource, inputResourceId, null, thePointcut);
                theRequestDetails.setFixedConditionalUrl(previousFixedConditionalUrl);
                if (newVerdict == null) continue;
                if (verdict == null) {
                    verdict = newVerdict;
                    continue;
                }
                if (verdict.getDecision() != PolicyEnum.ALLOW || newVerdict.getDecision() != PolicyEnum.DENY) continue;
                verdict = newVerdict;
            }
            if (allComponentsAreGets) {
                return this.newVerdict(theOperation, theRequestDetails, theInputResource, theInputResourceId, theOutputResource);
            }
            return verdict;
        }
        if (theOutputResource != null) {
            List<IBaseResource> outputResources = AuthorizationInterceptor.toListOfResourcesAndExcludeContainer(theOutputResource, theRequestDetails.getFhirContext());
            AuthorizationInterceptor.Verdict verdict = null;
            for (IBaseResource nextResource : outputResources) {
                AuthorizationInterceptor.Verdict newVerdict;
                if (nextResource == null || (newVerdict = theRuleApplier.applyRulesAndReturnDecision(RestOperationTypeEnum.READ, theRequestDetails, null, null, nextResource, thePointcut)) == null) continue;
                if (verdict == null) {
                    verdict = newVerdict;
                    continue;
                }
                if (verdict.getDecision() != PolicyEnum.ALLOW || newVerdict.getDecision() != PolicyEnum.DENY) continue;
                verdict = newVerdict;
            }
            return verdict;
        }
        return null;
    }

    private void setTargetFromResourceId(RequestDetails theRequestDetails, FhirContext ctx, RuleTarget target) {
        String[] idValues = theRequestDetails.getParameters().get("_id");
        target.resourceIds = new ArrayList<IIdType>();
        for (String nextIdValue : idValues) {
            QualifiedParamList orParamList = QualifiedParamList.splitQueryStringByCommasIgnoreEscape(null, (String)nextIdValue);
            for (String next : orParamList) {
                IIdType nextId = ctx.getVersion().newIdType().setValue(next);
                if (!nextId.hasIdPart()) continue;
                if (!nextId.hasResourceType()) {
                    nextId = nextId.withResourceType(target.resourceType);
                }
                if (!nextId.getResourceType().equals(target.resourceType)) continue;
                target.resourceIds.add(nextId);
            }
        }
        if (target.resourceIds.isEmpty()) {
            target.resourceIds = null;
        }
    }

    private AuthorizationInterceptor.Verdict checkForSearchParameterMatchingCompartmentAndReturnSuccessfulVerdictOrNull(Map<String, String[]> theSearchParams, IIdType theCompartmentOwner, String theSearchParamName, RestOperationTypeEnum theOperation, RequestDetails theRequestDetails, IBaseResource theInputResource, IIdType theInputResourceId, IBaseResource theOutputResource) {
        String[] values;
        AuthorizationInterceptor.Verdict verdict = null;
        if (theSearchParams != null && (values = theSearchParams.get(theSearchParamName)) != null) {
            block0: for (String nextParameterValue : values) {
                QualifiedParamList orParamList = QualifiedParamList.splitQueryStringByCommasIgnoreEscape(null, (String)nextParameterValue);
                for (String next : orParamList) {
                    if (next.equals(theCompartmentOwner.getValue())) {
                        verdict = this.newVerdict(theOperation, theRequestDetails, theInputResource, theInputResourceId, theOutputResource);
                        continue block0;
                    }
                    if (!next.equals(theCompartmentOwner.getIdPart())) continue;
                    verdict = this.newVerdict(theOperation, theRequestDetails, theInputResource, theInputResourceId, theOutputResource);
                    continue block0;
                }
            }
        }
        return verdict;
    }

    public void setTransactionAppliesToOp(TransactionAppliesToEnum theOp) {
        this.myTransactionAppliesToOp = theOp;
    }

    private boolean requestAppliesToTransaction(FhirContext theContext, RuleOpEnum theOp, IBaseResource theInputResource) {
        if (!"Bundle".equals(theContext.getResourceType(theInputResource))) {
            return false;
        }
        IBaseBundle request = (IBaseBundle)theInputResource;
        String bundleType = StringUtils.defaultString((String)BundleUtil.getBundleType((FhirContext)theContext, (IBaseBundle)request));
        if (theOp == RuleOpEnum.TRANSACTION) {
            if ("transaction".equals(bundleType) || "batch".equals(bundleType)) {
                return true;
            }
            String msg = theContext.getLocalizer().getMessage(RuleImplOp.class, "invalidRequestBundleTypeForTransaction", new Object[]{'\"' + bundleType + '\"'});
            throw new UnprocessableEntityException(msg);
        }
        return false;
    }

    public void setAppliesTo(AppliesTypeEnum theAppliesTo) {
        this.myAppliesTo = theAppliesTo;
    }

    void setAppliesToTypes(Set<String> theAppliesToTypes) {
        this.myAppliesToTypes = theAppliesToTypes;
    }

    void setClassifierCompartmentName(String theClassifierCompartmentName) {
        this.myClassifierCompartmentName = theClassifierCompartmentName;
    }

    void setClassifierCompartmentOwners(Collection<? extends IIdType> theInCompartmentOwners) {
        this.myClassifierCompartmentOwners = theInCompartmentOwners;
    }

    void setClassifierType(ClassifierTypeEnum theClassifierType) {
        this.myClassifierType = theClassifierType;
    }

    public RuleImplOp setOp(RuleOpEnum theRuleOp) {
        this.myOp = theRuleOp;
        return this;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        builder.append("op", (Object)this.myOp);
        builder.append("transactionAppliesToOp", (Object)this.myTransactionAppliesToOp);
        builder.append("appliesTo", (Object)this.myAppliesTo);
        builder.append("appliesToTypes", this.myAppliesToTypes);
        builder.append("classifierCompartmentName", (Object)this.myClassifierCompartmentName);
        builder.append("classifierCompartmentOwners", this.myClassifierCompartmentOwners);
        builder.append("classifierType", (Object)this.myClassifierType);
        return builder.toString();
    }

    void setAppliesToDeleteCascade(boolean theAppliesToDeleteCascade) {
        this.myAppliesToDeleteCascade = theAppliesToDeleteCascade;
    }

    void setAppliesToDeleteExpunge(boolean theAppliesToDeleteExpunge) {
        this.myAppliesToDeleteExpunge = theAppliesToDeleteExpunge;
    }

    public void addClassifierCompartmentOwner(IIdType theOwner) {
        ArrayList<? extends IIdType> newList = new ArrayList<IIdType>(this.myClassifierCompartmentOwners);
        newList.add((IIdType)theOwner);
        this.myClassifierCompartmentOwners = newList;
    }

    public boolean matches(RuleOpEnum theRuleOp, AppliesTypeEnum theAppliesTo, Collection<IIdType> theAppliesToInstances, Set<String> theAppliesToTypes, ClassifierTypeEnum theClassifierType, String theCompartmentName) {
        if (theRuleOp != this.myOp || theAppliesTo != this.myAppliesTo || theClassifierType != this.myClassifierType) {
            return false;
        }
        switch (theAppliesTo) {
            case TYPES: {
                return theAppliesToTypes.equals(this.myAppliesToTypes) && theCompartmentName.equals(this.myClassifierCompartmentName);
            }
            case INSTANCES: {
                return theAppliesToInstances.equals(this.myAppliesToInstances) && theCompartmentName.equals(this.myClassifierCompartmentName);
            }
            case ALL_RESOURCES: {
                return theCompartmentName.equals(this.myClassifierCompartmentName);
            }
        }
        return false;
    }

    public void setAdditionalSearchParamsForCompartmentTypes(AdditionalCompartmentSearchParameters theAdditionalParameters) {
        this.myAdditionalCompartmentSearchParamMap = theAdditionalParameters;
    }
}

