/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor.auth;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.Validate;

public class AuthorizedList {
    private List<String> myAllowedCompartments;
    private List<String> myAllowedInstances;

    List<String> getAllowedCompartments() {
        return this.myAllowedCompartments;
    }

    List<String> getAllowedInstances() {
        return this.myAllowedInstances;
    }

    public AuthorizedList addCompartment(String theCompartment) {
        Validate.notNull((Object)theCompartment, (String)"theCompartment must not be null", (Object[])new Object[0]);
        if (this.myAllowedCompartments == null) {
            this.myAllowedCompartments = new ArrayList<String>();
        }
        this.myAllowedCompartments.add(theCompartment);
        return this;
    }

    public AuthorizedList addCompartments(String ... theCompartments) {
        Validate.notNull((Object)theCompartments, (String)"theCompartments must not be null", (Object[])new Object[0]);
        for (String next : theCompartments) {
            this.addCompartment(next);
        }
        return this;
    }

    public AuthorizedList addResource(String theResource) {
        Validate.notNull((Object)theResource, (String)"theResource must not be null", (Object[])new Object[0]);
        if (this.myAllowedInstances == null) {
            this.myAllowedInstances = new ArrayList<String>();
        }
        this.myAllowedInstances.add(theResource);
        return this;
    }

    public AuthorizedList addResources(String ... theResources) {
        Validate.notNull((Object)theResources, (String)"theResources must not be null", (Object[])new Object[0]);
        for (String next : theResources) {
            this.addResource(next);
        }
        return this;
    }
}

