/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.fhirpath.FhirPathExecutionException;
import ca.uhn.fhir.fhirpath.IFhirPath;
import ca.uhn.fhir.interceptor.api.Hook;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.ResponseDetails;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.util.ParametersUtil;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class FhirPathFilterInterceptor {
    @Hook(value=Pointcut.SERVER_OUTGOING_RESPONSE)
    public void preProcessOutgoingResponse(RequestDetails theRequestDetails, ResponseDetails theResponseDetails) {
        String[] fhirPathParams;
        IBaseResource responseResource = theResponseDetails.getResponseResource();
        if (responseResource != null && (fhirPathParams = theRequestDetails.getParameters().get("_fhirpath")) != null) {
            FhirContext ctx = theRequestDetails.getFhirContext();
            IBaseParameters responseParameters = ParametersUtil.newInstance((FhirContext)ctx);
            for (String expression : fhirPathParams) {
                List outputs;
                if (!StringUtils.isNotBlank((CharSequence)expression)) continue;
                IBase resultPart = ParametersUtil.addParameterToParameters((FhirContext)ctx, (IBaseParameters)responseParameters, (String)"result");
                ParametersUtil.addPartString((FhirContext)ctx, (IBase)resultPart, (String)"expression", (String)expression);
                IFhirPath fhirPath = ctx.newFhirPath();
                try {
                    outputs = fhirPath.evaluate((IBase)responseResource, expression, IBase.class);
                }
                catch (FhirPathExecutionException e) {
                    throw new InvalidRequestException("Error parsing FHIRPath expression: " + e.getMessage());
                }
                for (IBase nextOutput : outputs) {
                    if (nextOutput instanceof IBaseResource) {
                        ParametersUtil.addPartResource((FhirContext)ctx, (IBase)resultPart, (String)"result", (IBaseResource)((IBaseResource)nextOutput));
                        continue;
                    }
                    ParametersUtil.addPart((FhirContext)ctx, (IBase)resultPart, (String)"result", (IBase)nextOutput);
                }
            }
            theResponseDetails.setResponseResource((IBaseResource)responseParameters);
        }
    }
}

