/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.tenant;

import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.tenant.ITenantIdentificationStrategy;
import ca.uhn.fhir.util.UrlPathTokenizer;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlBaseTenantIdentificationStrategy
implements ITenantIdentificationStrategy {
    private static final Logger ourLog = LoggerFactory.getLogger(UrlBaseTenantIdentificationStrategy.class);

    @Override
    public void extractTenant(UrlPathTokenizer theUrlPathTokenizer, RequestDetails theRequestDetails) {
        if (theUrlPathTokenizer.hasMoreTokens()) {
            String tenantId = theUrlPathTokenizer.nextToken();
            ourLog.trace("Found tenant ID {} in request string", (Object)tenantId);
            theRequestDetails.setTenantId(tenantId);
        }
    }

    @Override
    public String massageServerBaseUrl(String theFhirServerBase, RequestDetails theRequestDetails) {
        Validate.notNull((Object)theRequestDetails.getTenantId(), (String)"theTenantId is not populated on this request", (Object[])new Object[0]);
        return theFhirServerBase + '/' + theRequestDetails.getTenantId();
    }
}

