/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.servlet;

import ca.uhn.fhir.rest.api.MethodOutcome;
import ca.uhn.fhir.rest.api.server.ParseAction;
import ca.uhn.fhir.rest.server.RestfulResponse;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.hl7.fhir.instance.model.api.IBaseBinary;

public class ServletRestfulResponse
extends RestfulResponse<ServletRequestDetails> {
    public ServletRestfulResponse(ServletRequestDetails servletRequestDetails) {
        super(servletRequestDetails);
    }

    @Override
    public Object sendAttachmentResponse(IBaseBinary bin, int stausCode, String contentType) throws IOException {
        this.addHeaders();
        HttpServletResponse theHttpResponse = ((ServletRequestDetails)this.getRequestDetails()).getServletResponse();
        theHttpResponse.setStatus(stausCode);
        theHttpResponse.setContentType(contentType);
        if (bin.getContent() == null || bin.getContent().length == 0) {
            return theHttpResponse.getOutputStream();
        }
        theHttpResponse.setContentLength(bin.getContent().length);
        ServletOutputStream oos = theHttpResponse.getOutputStream();
        oos.write(bin.getContent());
        return oos;
    }

    @Override
    public Writer getResponseWriter(int theStatusCode, String theStatusMessage, String theContentType, String theCharset, boolean theRespondGzip) throws UnsupportedEncodingException, IOException {
        this.addHeaders();
        HttpServletResponse theHttpResponse = ((ServletRequestDetails)this.getRequestDetails()).getServletResponse();
        theHttpResponse.setCharacterEncoding(theCharset);
        theHttpResponse.setStatus(theStatusCode);
        theHttpResponse.setContentType(theContentType);
        if (theRespondGzip) {
            theHttpResponse.addHeader("Content-Encoding", "gzip");
            return new OutputStreamWriter((OutputStream)new GZIPOutputStream((OutputStream)theHttpResponse.getOutputStream()), "UTF-8");
        }
        return theHttpResponse.getWriter();
    }

    private void addHeaders() {
        HttpServletResponse theHttpResponse = ((ServletRequestDetails)this.getRequestDetails()).getServletResponse();
        ((ServletRequestDetails)this.getRequestDetails()).getServer().addHeadersToResponse(theHttpResponse);
        for (Map.Entry<String, String> header : this.getHeaders().entrySet()) {
            theHttpResponse.setHeader(header.getKey(), header.getValue());
        }
    }

    @Override
    public final Object sendWriterResponse(int theStatus, String theContentType, String theCharset, Writer theWriter) throws IOException {
        return theWriter;
    }

    @Override
    public Object returnResponse(ParseAction<?> outcome, int operationStatus, boolean allowPrefer, MethodOutcome response, String resourceName) throws IOException {
        this.addHeaders();
        return ((ServletRequestDetails)this.getRequestDetails()).getServer().returnResponse((ServletRequestDetails)this.getRequestDetails(), outcome, operationStatus, allowPrefer, response, resourceName);
    }
}

