/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.servlet;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.RestfulServer;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.servlet.ServletRestfulResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.GZIPInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletRequestDetails
extends RequestDetails {
    private static final Logger ourLog = LoggerFactory.getLogger(ServletRequestDetails.class);
    private RestfulServer myServer;
    private HttpServletRequest myServletRequest;
    private HttpServletResponse myServletResponse;

    public ServletRequestDetails() {
        this.setResponse(new ServletRestfulResponse(this));
    }

    @Override
    protected byte[] getByteStreamRequestContents() {
        try {
            String contentEncoding;
            InputStream inputStream = this.getInputStream();
            byte[] requestContents = IOUtils.toByteArray((InputStream)inputStream);
            if (this.myServer.isUncompressIncomingContents() && "gzip".equals(contentEncoding = this.myServletRequest.getHeader("Content-Encoding"))) {
                ourLog.debug("Uncompressing (GZip) incoming content");
                if (requestContents.length > 0) {
                    GZIPInputStream gis = new GZIPInputStream(new ByteArrayInputStream(requestContents));
                    requestContents = IOUtils.toByteArray((InputStream)gis);
                }
            }
            return requestContents;
        }
        catch (IOException e) {
            ourLog.error("Could not load request resource", (Throwable)e);
            throw new InvalidRequestException(String.format("Could not load request resource: %s", e.getMessage()));
        }
    }

    @Override
    public Charset getCharset() {
        Charset charset = null;
        String charsetString = this.myServletRequest.getCharacterEncoding();
        if (StringUtils.isNotBlank((CharSequence)charsetString)) {
            charset = Charset.forName(charsetString);
        }
        return charset;
    }

    @Override
    public FhirContext getFhirContext() {
        return this.getServer().getFhirContext();
    }

    @Override
    public String getHeader(String name) {
        return this.getServletRequest().getHeader(name);
    }

    @Override
    public List<String> getHeaders(String name) {
        Enumeration headers = this.getServletRequest().getHeaders(name);
        return headers == null ? Collections.emptyList() : Collections.list(this.getServletRequest().getHeaders(name));
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.getServletRequest().getInputStream();
    }

    @Override
    public Reader getReader() throws IOException {
        return this.getServletRequest().getReader();
    }

    @Override
    public RestfulServer getServer() {
        return this.myServer;
    }

    @Override
    public String getServerBaseForRequest() {
        return this.getServer().getServerBaseForRequest(this);
    }

    public HttpServletRequest getServletRequest() {
        return this.myServletRequest;
    }

    public HttpServletResponse getServletResponse() {
        return this.myServletResponse;
    }

    public void setServer(RestfulServer theServer) {
        this.myServer = theServer;
    }

    public void setServletRequest(HttpServletRequest myServletRequest) {
        this.myServletRequest = myServletRequest;
    }

    public void setServletResponse(HttpServletResponse myServletResponse) {
        this.myServletResponse = myServletResponse;
    }
}

