/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.method;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.rest.api.Constants;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.server.IRestfulServer;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.ParameterUtil;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.rest.server.method.BaseMethodBinding;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Method;

public class GraphQLMethodBinding
extends BaseMethodBinding<String> {
    private final Integer myIdParamIndex;

    public GraphQLMethodBinding(Method theMethod, FhirContext theContext, Object theProvider) {
        super(theMethod, theContext, theProvider);
        this.myIdParamIndex = ParameterUtil.findIdParameterIndex((Method)theMethod, (FhirContext)theContext);
    }

    @Override
    public String getResourceName() {
        return null;
    }

    @Override
    public RestOperationTypeEnum getRestOperationType() {
        return RestOperationTypeEnum.GRAPHQL_REQUEST;
    }

    @Override
    public boolean isGlobalMethod() {
        return true;
    }

    @Override
    public boolean incomingServerRequestMatchesMethod(RequestDetails theRequest) {
        return "$graphql".equals(theRequest.getOperation());
    }

    @Override
    public Object invokeServer(IRestfulServer<?> theServer, RequestDetails theRequest) throws BaseServerResponseException, IOException {
        Object[] methodParams = this.createMethodParams(theRequest);
        if (this.myIdParamIndex != null) {
            methodParams[this.myIdParamIndex.intValue()] = theRequest.getId();
        }
        Object response = this.invokeServerMethod(theServer, theRequest, methodParams);
        int statusCode = 200;
        String statusMessage = (String)Constants.HTTP_STATUS_NAMES.get(statusCode);
        String contentType = "application/json";
        String charset = "UTF-8";
        boolean respondGzip = theRequest.isRespondGzip();
        Writer writer = theRequest.getResponse().getResponseWriter(statusCode, statusMessage, contentType, charset, respondGzip);
        String responseString = (String)response;
        writer.write(responseString);
        writer.close();
        return null;
    }
}

