/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.method;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.api.QualifiedParamList;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.CompositeOrListParam;
import ca.uhn.fhir.rest.param.DateOrListParam;
import ca.uhn.fhir.rest.param.DateParam;
import ca.uhn.fhir.rest.param.NumberOrListParam;
import ca.uhn.fhir.rest.param.NumberParam;
import ca.uhn.fhir.rest.param.QuantityOrListParam;
import ca.uhn.fhir.rest.param.QuantityParam;
import ca.uhn.fhir.rest.param.ReferenceOrListParam;
import ca.uhn.fhir.rest.param.ReferenceParam;
import ca.uhn.fhir.rest.param.StringOrListParam;
import ca.uhn.fhir.rest.param.StringParam;
import ca.uhn.fhir.rest.param.TokenOrListParam;
import ca.uhn.fhir.rest.param.TokenParam;
import ca.uhn.fhir.rest.param.UriOrListParam;
import ca.uhn.fhir.rest.server.IDynamicSearchResourceProvider;
import ca.uhn.fhir.rest.server.SearchParameterMap;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.method.BaseMethodBinding;
import ca.uhn.fhir.rest.server.method.IParameter;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class DynamicSearchParameter
implements IParameter {
    private Map<String, RuntimeSearchParam> myNameToParam = new HashMap<String, RuntimeSearchParam>();

    public DynamicSearchParameter(IDynamicSearchResourceProvider theProvider) {
        for (RuntimeSearchParam next : theProvider.getSearchParameters()) {
            this.myNameToParam.put(next.getName(), next);
        }
    }

    @Override
    public Object translateQueryParametersIntoServerArgument(RequestDetails theRequest, BaseMethodBinding<?> theMethodBinding) throws InternalErrorException, InvalidRequestException {
        SearchParameterMap retVal = new SearchParameterMap();
        for (String next : theRequest.getParameters().keySet()) {
            String qualifier = null;
            String qualifiedParamName = next;
            String unqualifiedParamName = next;
            RuntimeSearchParam param = this.myNameToParam.get(next);
            if (param == null) {
                int colonIndex = next.indexOf(58);
                int dotIndex = next.indexOf(46);
                if (colonIndex != -1 || dotIndex != -1) {
                    int index = colonIndex != -1 && dotIndex != -1 ? Math.min(colonIndex, dotIndex) : (colonIndex != -1 ? colonIndex : dotIndex);
                    qualifier = next.substring(index);
                    unqualifiedParamName = next = next.substring(0, index);
                    param = this.myNameToParam.get(next);
                }
            }
            if (param == null) continue;
            block11: for (String nextValue : theRequest.getParameters().get(qualifiedParamName)) {
                QualifiedParamList paramList = QualifiedParamList.splitQueryStringByCommasIgnoreEscape((String)qualifier, (String)nextValue);
                FhirContext ctx = theRequest.getServer().getFhirContext();
                switch (param.getParamType()) {
                    case COMPOSITE: {
                        Class<? extends IQueryParameterType> left = this.toParamType((RuntimeSearchParam)param.getCompositeOf().get(0));
                        Class<? extends IQueryParameterType> right = this.toParamType((RuntimeSearchParam)param.getCompositeOf().get(0));
                        CompositeOrListParam compositeOrListParam = new CompositeOrListParam(left, right);
                        compositeOrListParam.setValuesAsQueryTokens(ctx, unqualifiedParamName, paramList);
                        retVal.add(next, compositeOrListParam);
                        continue block11;
                    }
                    case DATE: {
                        DateOrListParam dateOrListParam = new DateOrListParam();
                        dateOrListParam.setValuesAsQueryTokens(ctx, unqualifiedParamName, paramList);
                        retVal.add(next, dateOrListParam);
                        continue block11;
                    }
                    case NUMBER: {
                        NumberOrListParam numberOrListParam = new NumberOrListParam();
                        numberOrListParam.setValuesAsQueryTokens(ctx, unqualifiedParamName, paramList);
                        retVal.add(next, numberOrListParam);
                        continue block11;
                    }
                    case QUANTITY: {
                        QuantityOrListParam quantityOrListParam = new QuantityOrListParam();
                        quantityOrListParam.setValuesAsQueryTokens(ctx, unqualifiedParamName, paramList);
                        retVal.add(next, quantityOrListParam);
                        continue block11;
                    }
                    case REFERENCE: {
                        ReferenceOrListParam referenceOrListParam = new ReferenceOrListParam();
                        referenceOrListParam.setValuesAsQueryTokens(ctx, unqualifiedParamName, paramList);
                        retVal.add(next, referenceOrListParam);
                        continue block11;
                    }
                    case STRING: {
                        StringOrListParam stringOrListParam = new StringOrListParam();
                        stringOrListParam.setValuesAsQueryTokens(ctx, unqualifiedParamName, paramList);
                        retVal.add(next, stringOrListParam);
                        continue block11;
                    }
                    case TOKEN: {
                        TokenOrListParam tokenOrListParam = new TokenOrListParam();
                        tokenOrListParam.setValuesAsQueryTokens(ctx, unqualifiedParamName, paramList);
                        retVal.add(next, tokenOrListParam);
                        continue block11;
                    }
                    case URI: {
                        UriOrListParam uriOrListParam = new UriOrListParam();
                        uriOrListParam.setValuesAsQueryTokens(ctx, unqualifiedParamName, paramList);
                        retVal.add(next, uriOrListParam);
                        continue block11;
                    }
                }
            }
        }
        return retVal;
    }

    private Class<? extends IQueryParameterType> toParamType(RuntimeSearchParam theRuntimeSearchParam) {
        switch (theRuntimeSearchParam.getParamType()) {
            case COMPOSITE: {
                throw new IllegalStateException("Composite subtype");
            }
            case DATE: {
                return DateParam.class;
            }
            case NUMBER: {
                return NumberParam.class;
            }
            case QUANTITY: {
                return QuantityParam.class;
            }
            case REFERENCE: {
                return ReferenceParam.class;
            }
            case STRING: {
                return StringParam.class;
            }
            case TOKEN: {
                return TokenParam.class;
            }
        }
        throw new IllegalStateException("null type");
    }

    @Override
    public void initializeTypes(Method theMethod, Class<? extends Collection<?>> theOuterCollectionType, Class<? extends Collection<?>> theInnerCollectionType, Class<?> theParameterType) {
    }
}

