/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.method;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.rest.annotation.Create;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.method.BaseOutcomeReturningMethodBindingWithResourceParam;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;

public class CreateMethodBinding
extends BaseOutcomeReturningMethodBindingWithResourceParam {
    public CreateMethodBinding(Method theMethod, FhirContext theContext, Object theProvider) {
        super(theMethod, theContext, Create.class, theProvider);
    }

    @Override
    protected String getMatchingOperation() {
        return null;
    }

    @Override
    public RestOperationTypeEnum getRestOperationType() {
        return RestOperationTypeEnum.CREATE;
    }

    @Override
    protected Set<RequestTypeEnum> provideAllowableRequestTypes() {
        return Collections.singleton(RequestTypeEnum.POST);
    }

    @Override
    protected void validateResourceIdAndUrlIdForNonConditionalOperation(IBaseResource theResource, String theResourceId, String theUrlId, String theMatchUrl) {
        if (StringUtils.isNotBlank((CharSequence)theUrlId)) {
            String msg = this.getContext().getLocalizer().getMessage(BaseOutcomeReturningMethodBindingWithResourceParam.class, "idInUrlForCreate", new Object[]{theUrlId});
            throw new InvalidRequestException(msg);
        }
        if (this.getContext().getVersion().getVersion().isOlderThan(FhirVersionEnum.DSTU3)) {
            if (StringUtils.isNotBlank((CharSequence)theResourceId)) {
                String msg = this.getContext().getLocalizer().getMessage(BaseOutcomeReturningMethodBindingWithResourceParam.class, "idInBodyForCreate", new Object[]{theResourceId});
                throw new InvalidRequestException(msg);
            }
        } else {
            theResource.setId((IIdType)null);
        }
    }
}

