/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.method;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.base.resource.BaseOperationOutcome;
import ca.uhn.fhir.model.valueset.BundleTypeEnum;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.rest.api.IVersionSpecificBundleFactory;
import ca.uhn.fhir.rest.api.MethodOutcome;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.IRestfulServer;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.IPagingProvider;
import ca.uhn.fhir.rest.server.RestfulServerUtils;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import ca.uhn.fhir.rest.server.interceptor.IServerInterceptor;
import ca.uhn.fhir.rest.server.method.BaseMethodBinding;
import ca.uhn.fhir.util.ReflectionUtil;
import ca.uhn.fhir.util.UrlUtil;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseResourceReturningMethodBinding
extends BaseMethodBinding<Object> {
    protected static final Set<String> ALLOWED_PARAMS;
    private static final Logger ourLog;
    private MethodReturnTypeEnum myMethodReturnType;
    private String myResourceName;
    private Class<? extends IBaseResource> myResourceType;

    public BaseResourceReturningMethodBinding(Class<?> theReturnResourceType, Method theMethod, FhirContext theContext, Object theProvider) {
        super(theMethod, theContext, theProvider);
        Class<?> methodReturnType = theMethod.getReturnType();
        if (Collection.class.isAssignableFrom(methodReturnType)) {
            this.myMethodReturnType = MethodReturnTypeEnum.LIST_OF_RESOURCES;
            Class collectionType = ReflectionUtil.getGenericCollectionTypeOfMethodReturnType((Method)theMethod);
            if (collectionType != null && !Object.class.equals((Object)collectionType) && !IBaseResource.class.isAssignableFrom(collectionType)) {
                throw new ConfigurationException("Method " + theMethod.getDeclaringClass().getSimpleName() + "#" + theMethod.getName() + " returns an invalid collection generic type: " + collectionType);
            }
        } else if (IBaseResource.class.isAssignableFrom(methodReturnType)) {
            this.myMethodReturnType = !Modifier.isAbstract(methodReturnType.getModifiers()) && theContext.getResourceDefinition(methodReturnType).isBundle() ? MethodReturnTypeEnum.BUNDLE_RESOURCE : MethodReturnTypeEnum.RESOURCE;
        } else if (IBundleProvider.class.isAssignableFrom(methodReturnType)) {
            this.myMethodReturnType = MethodReturnTypeEnum.BUNDLE_PROVIDER;
        } else if (MethodOutcome.class.isAssignableFrom(methodReturnType)) {
            this.myMethodReturnType = MethodReturnTypeEnum.METHOD_OUTCOME;
        } else {
            throw new ConfigurationException("Invalid return type '" + methodReturnType.getCanonicalName() + "' on method '" + theMethod.getName() + "' on type: " + theMethod.getDeclaringClass().getCanonicalName());
        }
        if (theReturnResourceType != null && IBaseResource.class.isAssignableFrom(theReturnResourceType) && !Modifier.isAbstract(theReturnResourceType.getModifiers()) && !Modifier.isInterface(theReturnResourceType.getModifiers())) {
            this.myResourceType = theReturnResourceType;
            this.myResourceName = theContext.getResourceDefinition(this.myResourceType).getName();
        }
    }

    public MethodReturnTypeEnum getMethodReturnType() {
        return this.myMethodReturnType;
    }

    @Override
    public String getResourceName() {
        return this.myResourceName;
    }

    protected abstract BundleTypeEnum getResponseBundleType();

    public abstract ReturnTypeEnum getReturnType();

    @Override
    public Object invokeServer(IRestfulServer<?> theServer, RequestDetails theRequest) throws BaseServerResponseException, IOException {
        IBaseResource response = this.doInvokeServer(theServer, theRequest);
        Set<SummaryEnum> summaryMode = RestfulServerUtils.determineSummaryMode(theRequest);
        for (int i = theServer.getInterceptors().size() - 1; i >= 0; --i) {
            IServerInterceptor next = theServer.getInterceptors().get(i);
            boolean continueProcessing = next.outgoingResponse(theRequest, response);
            if (continueProcessing) continue;
            return null;
        }
        boolean prettyPrint = RestfulServerUtils.prettyPrintResponse(theServer, theRequest);
        return theRequest.getResponse().streamResponseAsResource(response, prettyPrint, summaryMode, 200, null, theRequest.isRespondGzip(), this.isAddContentLocationHeader());
    }

    public IBaseResource doInvokeServer(IRestfulServer<?> theServer, RequestDetails theRequest) {
        IBaseResource responseObject;
        Object[] params = this.createMethodParams(theRequest);
        Object resultObj = this.invokeServer(theServer, theRequest, params);
        Integer count = RestfulServerUtils.extractCountParameter(theRequest);
        switch (this.getReturnType()) {
            case BUNDLE: {
                Integer resultSize;
                Integer offsetI;
                String serverBase = theRequest.getServerBaseForRequest();
                StringBuilder b = new StringBuilder();
                b.append(serverBase);
                if (StringUtils.isNotBlank((CharSequence)theRequest.getRequestPath())) {
                    b.append('/');
                    b.append(theRequest.getRequestPath());
                }
                if (theRequest.getRequestType() == RequestTypeEnum.GET) {
                    boolean first = true;
                    Map<String, String[]> parameters = theRequest.getParameters();
                    for (String nextParamName : new TreeSet<String>(parameters.keySet())) {
                        for (String nextParamValue : parameters.get(nextParamName)) {
                            if (first) {
                                b.append('?');
                                first = false;
                            } else {
                                b.append('&');
                            }
                            b.append(UrlUtil.escapeUrlParam((String)nextParamName));
                            b.append('=');
                            b.append(UrlUtil.escapeUrlParam((String)nextParamValue));
                        }
                    }
                }
                String linkSelf = b.toString();
                if (this.getMethodReturnType() == MethodReturnTypeEnum.BUNDLE_RESOURCE) {
                    IPrimitiveType<Date> lastUpdated;
                    IBaseResource resource;
                    if (resultObj instanceof IBundleProvider) {
                        IBundleProvider result = (IBundleProvider)resultObj;
                        resource = result.getResources(0, 1).get(0);
                        lastUpdated = result.getPublished();
                    } else {
                        resource = (IBaseResource)resultObj;
                        lastUpdated = theServer.getFhirContext().getVersion().getLastUpdated(resource);
                    }
                    IVersionSpecificBundleFactory bundleFactory = theServer.getFhirContext().newBundleFactory();
                    bundleFactory.initializeWithBundleResource(resource);
                    bundleFactory.addRootPropertiesToBundle(null, theRequest.getFhirServerBase(), linkSelf, null, null, count, this.getResponseBundleType(), lastUpdated);
                    responseObject = resource;
                    break;
                }
                Set<Include> includes = this.getRequestIncludesFromParams(params);
                IBundleProvider result = (IBundleProvider)resultObj;
                if (count == null) {
                    count = result.preferredPageSize();
                }
                if ((offsetI = RestfulServerUtils.tryToExtractNamedParameter(theRequest, "_getpagesoffset")) == null || offsetI < 0) {
                    offsetI = 0;
                }
                int start = (resultSize = result.size()) != null ? Math.max(0, Math.min(offsetI, resultSize - 1)) : offsetI;
                RestfulServerUtils.ResponseEncoding responseEncoding = RestfulServerUtils.determineResponseEncodingNoDefault(theRequest, theServer.getDefaultResponseEncoding());
                EncodingEnum linkEncoding = theRequest.getParameters().containsKey("_format") && responseEncoding != null ? responseEncoding.getEncoding() : null;
                responseObject = this.createBundleFromBundleProvider(theServer, theRequest, count, linkSelf, includes, result, start, this.getResponseBundleType(), linkEncoding, null);
                break;
            }
            case RESOURCE: {
                IBaseResource resource;
                IBundleProvider result = (IBundleProvider)resultObj;
                if (result.size() == 0) {
                    throw new ResourceNotFoundException(theRequest.getId());
                }
                if (result.size() > 1) {
                    throw new InternalErrorException("Method returned multiple resources");
                }
                responseObject = resource = result.getResources(0, 1).get(0);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return responseObject;
    }

    protected IBaseResource createBundleFromBundleProvider(IRestfulServer<?> theServer, RequestDetails theRequest, Integer theLimit, String theLinkSelf, Set<Include> theIncludes, IBundleProvider theResult, int theOffset, BundleTypeEnum theBundleType, EncodingEnum theLinkEncoding, String theSearchId) {
        List<Object> resourceList;
        int numToReturn;
        IVersionSpecificBundleFactory bundleFactory = theServer.getFhirContext().newBundleFactory();
        String searchId = null;
        Integer numTotalResults = theResult.size();
        if (theServer.getPagingProvider() == null) {
            numToReturn = numTotalResults;
            resourceList = numToReturn > 0 ? theResult.getResources(0, numToReturn) : Collections.emptyList();
            RestfulServerUtils.validateResourceListNotNull(resourceList);
        } else {
            IPagingProvider pagingProvider = theServer.getPagingProvider();
            numToReturn = theLimit == null || theLimit.equals(0) ? pagingProvider.getDefaultPageSize() : Math.min(pagingProvider.getMaximumPageSize(), theLimit);
            if (numTotalResults != null) {
                numToReturn = Math.min(numToReturn, numTotalResults - theOffset);
            }
            resourceList = numToReturn > 0 ? theResult.getResources(theOffset, numToReturn + theOffset) : Collections.emptyList();
            RestfulServerUtils.validateResourceListNotNull(resourceList);
            if (theSearchId != null) {
                searchId = theSearchId;
            } else if ((numTotalResults == null || numTotalResults > numToReturn) && StringUtils.isBlank((CharSequence)(searchId = pagingProvider.storeResultList(theResult)))) {
                ourLog.info("Found {} results but paging provider did not provide an ID to use for paging", (Object)numTotalResults);
            }
        }
        for (IBaseResource next : resourceList) {
            if (next.getIdElement() != null && !next.getIdElement().isEmpty() || next instanceof BaseOperationOutcome) continue;
            throw new InternalErrorException("Server method returned resource of type[" + next.getClass().getSimpleName() + "] with no ID specified (IResource#setId(IdDt) must be called)");
        }
        String serverBase = theRequest.getFhirServerBase();
        boolean prettyPrint = RestfulServerUtils.prettyPrintResponse(theServer, theRequest);
        String linkPrev = null;
        String linkNext = null;
        if (searchId != null) {
            if (numTotalResults == null || theOffset + numToReturn < numTotalResults) {
                linkNext = RestfulServerUtils.createPagingLink(theIncludes, serverBase, searchId, theOffset + numToReturn, numToReturn, theRequest.getParameters(), prettyPrint, theBundleType);
            }
            if (theOffset > 0) {
                int start = Math.max(0, theOffset - theLimit);
                linkPrev = RestfulServerUtils.createPagingLink(theIncludes, serverBase, searchId, start, theLimit, theRequest.getParameters(), prettyPrint, theBundleType);
            }
        }
        bundleFactory.addRootPropertiesToBundle(theResult.getUuid(), serverBase, theLinkSelf, linkPrev, linkNext, theResult.size(), theBundleType, theResult.getPublished());
        bundleFactory.addResourcesToBundle(new ArrayList(resourceList), theBundleType, serverBase, theServer.getBundleInclusionRule(), theIncludes);
        if (theServer.getPagingProvider() != null) {
            int limit = theLimit != null ? theLimit.intValue() : theServer.getPagingProvider().getDefaultPageSize();
            limit = Math.min(limit, theServer.getPagingProvider().getMaximumPageSize());
        }
        return bundleFactory.getResourceBundle();
    }

    public abstract Object invokeServer(IRestfulServer<?> var1, RequestDetails var2, Object[] var3) throws InvalidRequestException, InternalErrorException;

    protected boolean isAddContentLocationHeader() {
        return true;
    }

    protected void setResourceName(String theResourceName) {
        this.myResourceName = theResourceName;
    }

    static {
        ourLog = LoggerFactory.getLogger(BaseResourceReturningMethodBinding.class);
        HashSet<String> set = new HashSet<String>();
        set.add("_format");
        set.add("_narrative");
        set.add("_pretty");
        set.add("_sort");
        set.add("_sort:asc");
        set.add("_sort:desc");
        set.add("_count");
        set.add("_summary");
        set.add("_elements");
        set.add("_raw");
        ALLOWED_PARAMS = Collections.unmodifiableSet(set);
    }

    public static enum ReturnTypeEnum {
        BUNDLE,
        RESOURCE;

    }

    public static enum MethodReturnTypeEnum {
        BUNDLE,
        BUNDLE_PROVIDER,
        BUNDLE_RESOURCE,
        LIST_OF_RESOURCES,
        METHOD_OUTCOME,
        RESOURCE;

    }
}

