/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor.auth;

import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.server.interceptor.auth.AppliesTypeEnum;
import ca.uhn.fhir.rest.server.interceptor.auth.ClassifierTypeEnum;
import ca.uhn.fhir.rest.server.interceptor.auth.IAuthRule;
import ca.uhn.fhir.rest.server.interceptor.auth.IAuthRuleBuilder;
import ca.uhn.fhir.rest.server.interceptor.auth.IAuthRuleBuilderOperation;
import ca.uhn.fhir.rest.server.interceptor.auth.IAuthRuleBuilderOperationNamed;
import ca.uhn.fhir.rest.server.interceptor.auth.IAuthRuleBuilderRule;
import ca.uhn.fhir.rest.server.interceptor.auth.IAuthRuleBuilderRuleConditional;
import ca.uhn.fhir.rest.server.interceptor.auth.IAuthRuleBuilderRuleConditionalClassifier;
import ca.uhn.fhir.rest.server.interceptor.auth.IAuthRuleBuilderRuleOp;
import ca.uhn.fhir.rest.server.interceptor.auth.IAuthRuleBuilderRuleOpClassifier;
import ca.uhn.fhir.rest.server.interceptor.auth.IAuthRuleBuilderRuleOpClassifierFinished;
import ca.uhn.fhir.rest.server.interceptor.auth.IAuthRuleBuilderRuleTransaction;
import ca.uhn.fhir.rest.server.interceptor.auth.IAuthRuleBuilderRuleTransactionOp;
import ca.uhn.fhir.rest.server.interceptor.auth.IAuthRuleFinished;
import ca.uhn.fhir.rest.server.interceptor.auth.OperationRule;
import ca.uhn.fhir.rest.server.interceptor.auth.PolicyEnum;
import ca.uhn.fhir.rest.server.interceptor.auth.RuleImplConditional;
import ca.uhn.fhir.rest.server.interceptor.auth.RuleImplOp;
import ca.uhn.fhir.rest.server.interceptor.auth.RuleOpEnum;
import ca.uhn.fhir.rest.server.interceptor.auth.TransactionAppliesToEnum;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;

public class RuleBuilder
implements IAuthRuleBuilder {
    private ArrayList<IAuthRule> myRules = new ArrayList();

    @Override
    public IAuthRuleBuilderRule allow() {
        return this.allow(null);
    }

    @Override
    public IAuthRuleBuilderRule allow(String theRuleName) {
        return new RuleBuilderRule(PolicyEnum.ALLOW, theRuleName);
    }

    @Override
    public IAuthRuleBuilderRuleOpClassifierFinished allowAll() {
        return this.allowAll(null);
    }

    @Override
    public IAuthRuleBuilderRuleOpClassifierFinished allowAll(String theRuleName) {
        this.myRules.add(new RuleImplOp(theRuleName).setOp(RuleOpEnum.ALLOW_ALL));
        return new RuleBuilderFinished();
    }

    @Override
    public List<IAuthRule> build() {
        return this.myRules;
    }

    @Override
    public IAuthRuleBuilderRule deny() {
        return this.deny(null);
    }

    @Override
    public IAuthRuleBuilderRule deny(String theRuleName) {
        return new RuleBuilderRule(PolicyEnum.DENY, theRuleName);
    }

    @Override
    public IAuthRuleBuilderRuleOpClassifierFinished denyAll() {
        return this.denyAll(null);
    }

    @Override
    public IAuthRuleBuilderRuleOpClassifierFinished denyAll(String theRuleName) {
        this.myRules.add(new RuleImplOp(theRuleName).setOp(RuleOpEnum.DENY_ALL));
        return new RuleBuilderFinished();
    }

    private class RuleBuilderRule
    implements IAuthRuleBuilderRule {
        private PolicyEnum myRuleMode;
        private String myRuleName;
        private RuleOpEnum myRuleOp;

        public RuleBuilderRule(PolicyEnum theRuleMode, String theRuleName) {
            this.myRuleMode = theRuleMode;
            this.myRuleName = theRuleName;
        }

        @Override
        public IAuthRuleBuilderRuleConditional createConditional() {
            return new RuleBuilderRuleConditional(RestOperationTypeEnum.CREATE);
        }

        @Override
        public IAuthRuleBuilderRuleOp delete() {
            this.myRuleOp = RuleOpEnum.DELETE;
            return new RuleBuilderRuleOp();
        }

        @Override
        public IAuthRuleBuilderRuleConditional deleteConditional() {
            return new RuleBuilderRuleConditional(RestOperationTypeEnum.DELETE);
        }

        @Override
        public RuleBuilderFinished metadata() {
            RuleImplOp rule = new RuleImplOp(this.myRuleName);
            rule.setOp(RuleOpEnum.METADATA);
            rule.setMode(this.myRuleMode);
            RuleBuilder.this.myRules.add(rule);
            return new RuleBuilderFinished();
        }

        @Override
        public IAuthRuleBuilderOperation operation() {
            return new RuleBuilderRuleOperation();
        }

        @Override
        public IAuthRuleBuilderRuleOp read() {
            this.myRuleOp = RuleOpEnum.READ;
            return new RuleBuilderRuleOp();
        }

        @Override
        public IAuthRuleBuilderRuleTransaction transaction() {
            this.myRuleOp = RuleOpEnum.TRANSACTION;
            return new RuleBuilderRuleTransaction();
        }

        @Override
        public IAuthRuleBuilderRuleConditional updateConditional() {
            return new RuleBuilderRuleConditional(RestOperationTypeEnum.UPDATE);
        }

        @Override
        public IAuthRuleBuilderRuleOp write() {
            this.myRuleOp = RuleOpEnum.WRITE;
            return new RuleBuilderRuleOp();
        }

        private class RuleBuilderRuleTransaction
        implements IAuthRuleBuilderRuleTransaction {
            private RuleBuilderRuleTransaction() {
            }

            @Override
            public IAuthRuleBuilderRuleTransactionOp withAnyOperation() {
                return new RuleBuilderRuleTransactionOp();
            }

            private class RuleBuilderRuleTransactionOp
            implements IAuthRuleBuilderRuleTransactionOp {
                private RuleBuilderRuleTransactionOp() {
                }

                @Override
                public IAuthRuleBuilderRuleOpClassifierFinished andApplyNormalRules() {
                    RuleImplOp rule = new RuleImplOp(RuleBuilderRule.this.myRuleName);
                    rule.setMode(RuleBuilderRule.this.myRuleMode);
                    rule.setOp(RuleBuilderRule.this.myRuleOp);
                    rule.setTransactionAppliesToOp(TransactionAppliesToEnum.ANY_OPERATION);
                    RuleBuilder.this.myRules.add(rule);
                    return new RuleBuilderFinished();
                }
            }
        }

        private class RuleBuilderRuleOperation
        implements IAuthRuleBuilderOperation {
            private RuleBuilderRuleOperation() {
            }

            @Override
            public IAuthRuleBuilderOperationNamed named(String theOperationName) {
                Validate.notBlank((CharSequence)theOperationName, (String)"theOperationName must not be null or empty", (Object[])new Object[0]);
                return new RuleBuilderRuleOperationNamed(theOperationName);
            }

            @Override
            public IAuthRuleBuilderOperationNamed withAnyName() {
                return new RuleBuilderRuleOperationNamed(null);
            }

            private class RuleBuilderRuleOperationNamed
            implements IAuthRuleBuilderOperationNamed {
                private String myOperationName;

                public RuleBuilderRuleOperationNamed(String theOperationName) {
                    this.myOperationName = theOperationName != null && !theOperationName.startsWith("$") ? '$' + theOperationName : theOperationName;
                }

                private OperationRule createRule() {
                    OperationRule rule = new OperationRule(RuleBuilderRule.this.myRuleName);
                    rule.setOperationName(this.myOperationName);
                    rule.setMode(RuleBuilderRule.this.myRuleMode);
                    return rule;
                }

                @Override
                public IAuthRuleBuilderRuleOpClassifierFinished onInstance(IIdType theInstanceId) {
                    Validate.notNull((Object)theInstanceId, (String)"theInstanceId must not be null", (Object[])new Object[0]);
                    Validate.notBlank((CharSequence)theInstanceId.getResourceType(), (String)"theInstanceId does not have a resource type", (Object[])new Object[0]);
                    Validate.notBlank((CharSequence)theInstanceId.getIdPart(), (String)"theInstanceId does not have an ID part", (Object[])new Object[0]);
                    OperationRule rule = this.createRule();
                    ArrayList<IIdType> ids = new ArrayList<IIdType>();
                    ids.add(theInstanceId);
                    rule.appliesToInstances(ids);
                    RuleBuilder.this.myRules.add(rule);
                    return new RuleBuilderFinished();
                }

                @Override
                public IAuthRuleBuilderRuleOpClassifierFinished onServer() {
                    OperationRule rule = this.createRule();
                    rule.appliesToServer();
                    RuleBuilder.this.myRules.add(rule);
                    return new RuleBuilderFinished();
                }

                @Override
                public IAuthRuleBuilderRuleOpClassifierFinished onType(Class<? extends IBaseResource> theType) {
                    this.validateType(theType);
                    OperationRule rule = this.createRule();
                    rule.appliesToTypes(this.toTypeSet(theType));
                    RuleBuilder.this.myRules.add(rule);
                    return new RuleBuilderFinished();
                }

                private void validateType(Class<? extends IBaseResource> theType) {
                    Validate.notNull(theType, (String)"theType must not be null", (Object[])new Object[0]);
                }

                @Override
                public IAuthRuleBuilderRuleOpClassifierFinished onInstancesOfType(Class<? extends IBaseResource> theType) {
                    this.validateType(theType);
                    OperationRule rule = this.createRule();
                    rule.appliesToInstancesOfType(this.toTypeSet(theType));
                    RuleBuilder.this.myRules.add(rule);
                    return new RuleBuilderFinished();
                }

                private HashSet<Class<? extends IBaseResource>> toTypeSet(Class<? extends IBaseResource> theType) {
                    HashSet<Class<? extends IBaseResource>> appliesToTypes = new HashSet<Class<? extends IBaseResource>>();
                    appliesToTypes.add(theType);
                    return appliesToTypes;
                }

                @Override
                public IAuthRuleFinished onAnyType() {
                    OperationRule rule = this.createRule();
                    rule.appliesToAnyType();
                    RuleBuilder.this.myRules.add(rule);
                    return new RuleBuilderFinished();
                }

                @Override
                public IAuthRuleFinished onAnyInstance() {
                    OperationRule rule = this.createRule();
                    rule.appliesToAnyInstance();
                    RuleBuilder.this.myRules.add(rule);
                    return new RuleBuilderFinished();
                }
            }
        }

        private class RuleBuilderRuleOp
        implements IAuthRuleBuilderRuleOp {
            private AppliesTypeEnum myAppliesTo;
            private Set<?> myAppliesToTypes;

            private RuleBuilderRuleOp() {
            }

            @Override
            public IAuthRuleBuilderRuleOpClassifier allResources() {
                this.myAppliesTo = AppliesTypeEnum.ALL_RESOURCES;
                return new RuleBuilderRuleOpClassifier();
            }

            @Override
            public IAuthRuleBuilderRuleOpClassifier resourcesOfType(Class<? extends IBaseResource> theType) {
                Validate.notNull(theType, (String)"theType must not be null", (Object[])new Object[0]);
                this.myAppliesTo = AppliesTypeEnum.TYPES;
                this.myAppliesToTypes = Collections.singleton(theType);
                return new RuleBuilderRuleOpClassifier();
            }

            @Override
            public IAuthRuleFinished instance(String theId) {
                Validate.notBlank((CharSequence)theId, (String)"theId must not be null or empty", (Object[])new Object[0]);
                return this.instance((IIdType)new IdDt(theId));
            }

            @Override
            public IAuthRuleFinished instance(IIdType theId) {
                Validate.notNull((Object)theId, (String)"theId must not be null", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)theId.getValue(), (String)"theId.getValue() must not be null or empty", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)theId.getIdPart(), (String)"theId must contain an ID part", (Object[])new Object[0]);
                return new RuleBuilderRuleOpClassifier(Arrays.asList(theId)).finished();
            }

            private class RuleBuilderRuleOpClassifier
            implements IAuthRuleBuilderRuleOpClassifier {
                private ClassifierTypeEnum myClassifierType;
                private String myInCompartmentName;
                private Collection<? extends IIdType> myInCompartmentOwners;
                private List<IIdType> myAppliesToInstances;

                public RuleBuilderRuleOpClassifier() {
                }

                public RuleBuilderRuleOpClassifier(List<IIdType> theAppliesToInstances) {
                    this.myAppliesToInstances = theAppliesToInstances;
                    RuleBuilderRuleOp.this.myAppliesTo = AppliesTypeEnum.INSTANCES;
                }

                private IAuthRuleBuilderRuleOpClassifierFinished finished() {
                    RuleImplOp rule = new RuleImplOp(RuleBuilderRule.this.myRuleName);
                    rule.setMode(RuleBuilderRule.this.myRuleMode);
                    rule.setOp(RuleBuilderRule.this.myRuleOp);
                    rule.setAppliesTo(RuleBuilderRuleOp.this.myAppliesTo);
                    rule.setAppliesToTypes(RuleBuilderRuleOp.this.myAppliesToTypes);
                    rule.setAppliesToInstances(this.myAppliesToInstances);
                    rule.setClassifierType(this.myClassifierType);
                    rule.setClassifierCompartmentName(this.myInCompartmentName);
                    rule.setClassifierCompartmentOwners(this.myInCompartmentOwners);
                    RuleBuilder.this.myRules.add(rule);
                    return new RuleBuilderFinished();
                }

                @Override
                public IAuthRuleBuilderRuleOpClassifierFinished inCompartment(String theCompartmentName, Collection<? extends IIdType> theOwners) {
                    Validate.notBlank((CharSequence)theCompartmentName, (String)"theCompartmentName must not be null", (Object[])new Object[0]);
                    Validate.notNull(theOwners, (String)"theOwners must not be null", (Object[])new Object[0]);
                    Validate.noNullElements(theOwners, (String)"theOwners must not contain any null elements", (Object[])new Object[0]);
                    for (IIdType iIdType : theOwners) {
                        this.validateOwner(iIdType);
                    }
                    this.myClassifierType = ClassifierTypeEnum.IN_COMPARTMENT;
                    return this.finished();
                }

                @Override
                public IAuthRuleBuilderRuleOpClassifierFinished inCompartment(String theCompartmentName, IIdType theOwner) {
                    Validate.notBlank((CharSequence)theCompartmentName, (String)"theCompartmentName must not be null", (Object[])new Object[0]);
                    Validate.notNull((Object)theOwner, (String)"theOwner must not be null", (Object[])new Object[0]);
                    this.validateOwner(theOwner);
                    this.myInCompartmentName = theCompartmentName;
                    this.myInCompartmentOwners = Collections.singletonList(theOwner);
                    this.myClassifierType = ClassifierTypeEnum.IN_COMPARTMENT;
                    return this.finished();
                }

                private void validateOwner(IIdType theOwner) {
                    Validate.notBlank((CharSequence)theOwner.getIdPart(), (String)"owner.getIdPart() must not be null or empty", (Object[])new Object[0]);
                    Validate.notBlank((CharSequence)theOwner.getIdPart(), (String)"owner.getResourceType() must not be null or empty", (Object[])new Object[0]);
                }

                @Override
                public IAuthRuleBuilderRuleOpClassifierFinished withAnyId() {
                    this.myClassifierType = ClassifierTypeEnum.ANY_ID;
                    return this.finished();
                }
            }
        }

        private class RuleBuilderRuleConditional
        implements IAuthRuleBuilderRuleConditional {
            private AppliesTypeEnum myAppliesTo;
            private Set<?> myAppliesToTypes;
            private RestOperationTypeEnum myOperationType;

            public RuleBuilderRuleConditional(RestOperationTypeEnum theOperationType) {
                this.myOperationType = theOperationType;
            }

            @Override
            public IAuthRuleBuilderRuleConditionalClassifier allResources() {
                this.myAppliesTo = AppliesTypeEnum.ALL_RESOURCES;
                return new RuleBuilderRuleConditionalClassifier();
            }

            @Override
            public IAuthRuleBuilderRuleConditionalClassifier resourcesOfType(Class<? extends IBaseResource> theType) {
                Validate.notNull(theType, (String)"theType must not be null", (Object[])new Object[0]);
                this.myAppliesTo = AppliesTypeEnum.TYPES;
                this.myAppliesToTypes = Collections.singleton(theType);
                return new RuleBuilderRuleConditionalClassifier();
            }

            public class RuleBuilderRuleConditionalClassifier
            extends RuleBuilderFinished
            implements IAuthRuleBuilderRuleConditionalClassifier {
                @Override
                protected void doBuildRule() {
                    RuleImplConditional rule = new RuleImplConditional(RuleBuilderRule.this.myRuleName);
                    rule.setMode(RuleBuilderRule.this.myRuleMode);
                    rule.setOperationType(RuleBuilderRuleConditional.this.myOperationType);
                    rule.setAppliesTo(RuleBuilderRuleConditional.this.myAppliesTo);
                    rule.setAppliesToTypes(RuleBuilderRuleConditional.this.myAppliesToTypes);
                    RuleBuilder.this.myRules.add(rule);
                }
            }
        }
    }

    private class RuleBuilderFinished
    implements IAuthRuleFinished,
    IAuthRuleBuilderRuleOpClassifierFinished {
        private RuleBuilderFinished() {
        }

        @Override
        public IAuthRuleBuilder andThen() {
            this.doBuildRule();
            return RuleBuilder.this;
        }

        @Override
        public List<IAuthRule> build() {
            this.doBuildRule();
            return RuleBuilder.this.myRules;
        }

        protected void doBuildRule() {
        }
    }
}

