/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server;

import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import java.util.Collections;
import java.util.List;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class SimpleBundleProvider
implements IBundleProvider {
    private List<IBaseResource> myList;

    public SimpleBundleProvider(List<IBaseResource> theList) {
        this.myList = theList;
    }

    public SimpleBundleProvider(IBaseResource theResource) {
        this.myList = Collections.singletonList(theResource);
    }

    public SimpleBundleProvider() {
        this.myList = Collections.emptyList();
    }

    @Override
    public List<IBaseResource> getResources(int theFromIndex, int theToIndex) {
        return this.myList.subList(theFromIndex, Math.min(theToIndex, this.myList.size()));
    }

    @Override
    public Integer size() {
        return this.myList.size();
    }

    public InstantDt getPublished() {
        return InstantDt.withCurrentTime();
    }

    @Override
    public Integer preferredPageSize() {
        return null;
    }

    @Override
    public String getUuid() {
        return null;
    }
}

