/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.api.server;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.server.IRequestOperationCallback;
import ca.uhn.fhir.rest.api.server.IRestfulResponse;
import ca.uhn.fhir.rest.server.IRestfulServerDefaults;
import ca.uhn.fhir.rest.server.interceptor.IServerInterceptor;
import ca.uhn.fhir.rest.server.interceptor.IServerOperationInterceptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;

public abstract class RequestDetails {
    private String myTenantId;
    private String myCompartmentName;
    private String myCompleteUrl;
    private String myFhirServerBase;
    private IIdType myId;
    private String myOperation;
    private Map<String, String[]> myParameters;
    private byte[] myRequestContents;
    private IRequestOperationCallback myRequestOperationCallback = new RequestOperationCallback();
    private String myRequestPath;
    private RequestTypeEnum myRequestType;
    private String myResourceName;
    private boolean myRespondGzip;
    private IRestfulResponse myResponse;
    private RestOperationTypeEnum myRestOperationType;
    private String mySecondaryOperation;
    private boolean mySubRequest;
    private Map<String, List<String>> myUnqualifiedToQualifiedNames;
    private Map<Object, Object> myUserData;

    protected abstract byte[] getByteStreamRequestContents();

    public abstract Charset getCharset();

    public String getCompartmentName() {
        return this.myCompartmentName;
    }

    public void setCompartmentName(String theCompartmentName) {
        this.myCompartmentName = theCompartmentName;
    }

    public String getCompleteUrl() {
        return this.myCompleteUrl;
    }

    public void setCompleteUrl(String theCompleteUrl) {
        this.myCompleteUrl = theCompleteUrl;
    }

    public String getConditionalUrl(RestOperationTypeEnum theOperationType) {
        if (theOperationType == RestOperationTypeEnum.CREATE) {
            String retVal = this.getHeader("If-None-Exist");
            if (StringUtils.isBlank((CharSequence)retVal)) {
                return null;
            }
            if (retVal.startsWith(this.getFhirServerBase())) {
                retVal = retVal.substring(this.getFhirServerBase().length());
            }
            return retVal;
        }
        if (theOperationType != RestOperationTypeEnum.DELETE && theOperationType != RestOperationTypeEnum.UPDATE) {
            return null;
        }
        if (this.getId() != null && this.getId().hasIdPart()) {
            return null;
        }
        int questionMarkIndex = this.getCompleteUrl().indexOf(63);
        if (questionMarkIndex == -1) {
            return null;
        }
        return this.getResourceName() + this.getCompleteUrl().substring(questionMarkIndex);
    }

    public abstract FhirContext getFhirContext();

    public String getFhirServerBase() {
        return this.myFhirServerBase;
    }

    public void setFhirServerBase(String theFhirServerBase) {
        this.myFhirServerBase = theFhirServerBase;
    }

    public abstract String getHeader(String var1);

    public abstract List<String> getHeaders(String var1);

    public IIdType getId() {
        return this.myId;
    }

    public void setId(IIdType theId) {
        this.myId = theId;
    }

    public abstract InputStream getInputStream() throws IOException;

    public String getOperation() {
        return this.myOperation;
    }

    public void setOperation(String theOperation) {
        this.myOperation = theOperation;
    }

    public Map<String, String[]> getParameters() {
        if (this.myParameters == null) {
            return Collections.emptyMap();
        }
        return this.myParameters;
    }

    public void setParameters(Map<String, String[]> theParams) {
        this.myParameters = theParams;
        block0: for (String next : theParams.keySet()) {
            for (int i = 0; i < next.length(); ++i) {
                String unqualified;
                List<String> list;
                char nextChar = next.charAt(i);
                if (nextChar != ':' && nextChar != '.') continue;
                if (this.myUnqualifiedToQualifiedNames == null) {
                    this.myUnqualifiedToQualifiedNames = new HashMap<String, List<String>>();
                }
                if ((list = this.myUnqualifiedToQualifiedNames.get(unqualified = next.substring(0, i))) == null) {
                    list = new ArrayList<String>(4);
                    this.myUnqualifiedToQualifiedNames.put(unqualified, list);
                }
                list.add(next);
                continue block0;
            }
        }
        if (this.myUnqualifiedToQualifiedNames == null) {
            this.myUnqualifiedToQualifiedNames = Collections.emptyMap();
        }
    }

    public abstract Reader getReader() throws IOException;

    public IRequestOperationCallback getRequestOperationCallback() {
        return this.myRequestOperationCallback;
    }

    public String getRequestPath() {
        return this.myRequestPath;
    }

    public void setRequestPath(String theRequestPath) {
        assert (theRequestPath.length() == 0 || theRequestPath.charAt(0) != '/');
        this.myRequestPath = theRequestPath;
    }

    public RequestTypeEnum getRequestType() {
        return this.myRequestType;
    }

    public void setRequestType(RequestTypeEnum theRequestType) {
        this.myRequestType = theRequestType;
    }

    public String getResourceName() {
        return this.myResourceName;
    }

    public void setResourceName(String theResourceName) {
        this.myResourceName = theResourceName;
    }

    public IRestfulResponse getResponse() {
        return this.myResponse;
    }

    public void setResponse(IRestfulResponse theResponse) {
        this.myResponse = theResponse;
    }

    public RestOperationTypeEnum getRestOperationType() {
        return this.myRestOperationType;
    }

    public void setRestOperationType(RestOperationTypeEnum theRestOperationType) {
        this.myRestOperationType = theRestOperationType;
    }

    public String getSecondaryOperation() {
        return this.mySecondaryOperation;
    }

    public void setSecondaryOperation(String theSecondaryOperation) {
        this.mySecondaryOperation = theSecondaryOperation;
    }

    public abstract IRestfulServerDefaults getServer();

    public abstract String getServerBaseForRequest();

    public String getTenantId() {
        return this.myTenantId;
    }

    public void setTenantId(String theTenantId) {
        this.myTenantId = theTenantId;
    }

    public Map<String, List<String>> getUnqualifiedToQualifiedNames() {
        return this.myUnqualifiedToQualifiedNames;
    }

    public Map<Object, Object> getUserData() {
        if (this.myUserData == null) {
            this.myUserData = new HashMap<Object, Object>();
        }
        return this.myUserData;
    }

    public boolean isRespondGzip() {
        return this.myRespondGzip;
    }

    public void setRespondGzip(boolean theRespondGzip) {
        this.myRespondGzip = theRespondGzip;
    }

    public boolean isSubRequest() {
        return this.mySubRequest;
    }

    public void setSubRequest(boolean theSubRequest) {
        this.mySubRequest = theSubRequest;
    }

    public final byte[] loadRequestContents() {
        if (this.myRequestContents == null) {
            this.myRequestContents = this.getByteStreamRequestContents();
        }
        return this.myRequestContents;
    }

    public void setRequestContents(byte[] theRequestContents) {
        this.myRequestContents = theRequestContents;
    }

    private class RequestOperationCallback
    implements IRequestOperationCallback {
        private RequestOperationCallback() {
        }

        private List<IServerInterceptor> getInterceptors() {
            if (RequestDetails.this.getServer() == null) {
                return Collections.emptyList();
            }
            return RequestDetails.this.getServer().getInterceptors();
        }

        @Override
        public void resourceCreated(IBaseResource theResource) {
            for (IServerInterceptor next : this.getInterceptors()) {
                if (!(next instanceof IServerOperationInterceptor)) continue;
                ((IServerOperationInterceptor)next).resourceCreated(RequestDetails.this, theResource);
            }
        }

        @Override
        public void resourceDeleted(IBaseResource theResource) {
            for (IServerInterceptor next : this.getInterceptors()) {
                if (!(next instanceof IServerOperationInterceptor)) continue;
                ((IServerOperationInterceptor)next).resourceDeleted(RequestDetails.this, theResource);
            }
        }

        @Override
        public void resourcePreCreate(IBaseResource theResource) {
            for (IServerInterceptor next : this.getInterceptors()) {
                if (!(next instanceof IServerOperationInterceptor)) continue;
                ((IServerOperationInterceptor)next).resourcePreCreate(RequestDetails.this, theResource);
            }
        }

        @Override
        public void resourcePreDelete(IBaseResource theResource) {
            for (IServerInterceptor next : this.getInterceptors()) {
                if (!(next instanceof IServerOperationInterceptor)) continue;
                ((IServerOperationInterceptor)next).resourcePreDelete(RequestDetails.this, theResource);
            }
        }

        @Override
        public void resourcePreUpdate(IBaseResource theOldResource, IBaseResource theNewResource) {
            for (IServerInterceptor next : this.getInterceptors()) {
                if (!(next instanceof IServerOperationInterceptor)) continue;
                ((IServerOperationInterceptor)next).resourcePreUpdate(RequestDetails.this, theOldResource, theNewResource);
            }
        }

        @Override
        @Deprecated
        public void resourceUpdated(IBaseResource theResource) {
            for (IServerInterceptor next : this.getInterceptors()) {
                if (!(next instanceof IServerOperationInterceptor)) continue;
                ((IServerOperationInterceptor)next).resourceUpdated(RequestDetails.this, theResource);
            }
        }

        @Override
        public void resourceUpdated(IBaseResource theOldResource, IBaseResource theNewResource) {
            for (IServerInterceptor next : this.getInterceptors()) {
                if (!(next instanceof IServerOperationInterceptor)) continue;
                ((IServerOperationInterceptor)next).resourceUpdated(RequestDetails.this, theOldResource, theNewResource);
            }
        }

        @Override
        public void resourcesCreated(Collection<? extends IBaseResource> theResource) {
            for (IBaseResource iBaseResource : theResource) {
                this.resourceCreated(iBaseResource);
            }
        }

        @Override
        public void resourcesDeleted(Collection<? extends IBaseResource> theResource) {
            for (IBaseResource iBaseResource : theResource) {
                this.resourceDeleted(iBaseResource);
            }
        }

        @Override
        @Deprecated
        public void resourcesUpdated(Collection<? extends IBaseResource> theResource) {
            for (IBaseResource iBaseResource : theResource) {
                this.resourceUpdated(iBaseResource);
            }
        }
    }
}

