/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.validation;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.util.OperationOutcomeUtil;
import ca.uhn.fhir.validation.ResultSeverityEnum;
import ca.uhn.fhir.validation.SingleValidationMessage;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;

public class ValidationResult {
    public static final int ERROR_DISPLAY_LIMIT_DEFAULT = 1;
    public static final String UNKNOWN = "(unknown)";
    private static final String ourNewLine = System.getProperty("line.separator");
    private final FhirContext myCtx;
    private final boolean myIsSuccessful;
    private final List<SingleValidationMessage> myMessages;
    private int myErrorDisplayLimit = 1;

    public ValidationResult(FhirContext theCtx, List<SingleValidationMessage> theMessages) {
        boolean successful = true;
        this.myCtx = theCtx;
        this.myMessages = theMessages;
        for (SingleValidationMessage next : this.myMessages) {
            if (next.getSeverity() != null && next.getSeverity().ordinal() <= ResultSeverityEnum.WARNING.ordinal()) continue;
            successful = false;
            break;
        }
        this.myIsSuccessful = successful;
    }

    public List<SingleValidationMessage> getMessages() {
        return Collections.unmodifiableList(this.myMessages);
    }

    public boolean isSuccessful() {
        return this.myIsSuccessful;
    }

    private String toDescription() {
        if (this.myMessages.isEmpty()) {
            return "No issues";
        }
        StringBuilder b = new StringBuilder(100 * this.myMessages.size());
        int shownMsgQty = Math.min(this.myErrorDisplayLimit, this.myMessages.size());
        if (shownMsgQty < this.myMessages.size()) {
            b.append("(showing first ").append(shownMsgQty).append(" messages out of ").append(this.myMessages.size()).append(" total)").append(ourNewLine);
        }
        for (int i = 0; i < shownMsgQty; ++i) {
            SingleValidationMessage nextMsg = this.myMessages.get(i);
            b.append(ourNewLine);
            if (nextMsg.getSeverity() != null) {
                b.append(nextMsg.getSeverity().name());
                b.append(" - ");
            }
            b.append(nextMsg.getMessage());
            b.append(" - ");
            b.append(nextMsg.getLocationString());
        }
        return b.toString();
    }

    @Deprecated
    public IBaseOperationOutcome getOperationOutcome() {
        return this.toOperationOutcome();
    }

    public IBaseOperationOutcome toOperationOutcome() {
        IBaseOperationOutcome oo = (IBaseOperationOutcome)this.myCtx.getResourceDefinition("OperationOutcome").newInstance();
        this.populateOperationOutcome(oo);
        return oo;
    }

    public void populateOperationOutcome(IBaseOperationOutcome theOperationOutcome) {
        for (SingleValidationMessage next : this.myMessages) {
            Integer locationLine = next.getLocationLine();
            Integer locationCol = next.getLocationCol();
            String location = next.getLocationString();
            ResultSeverityEnum issueSeverity = next.getSeverity();
            String message = next.getMessage();
            String messageId = next.getMessageId();
            if (next.getSliceMessages() == null) {
                this.addIssueToOperationOutcome(theOperationOutcome, location, locationLine, locationCol, issueSeverity, message, messageId);
                continue;
            }
            for (String nextSliceMessage : next.getSliceMessages()) {
                String combinedMessage = message + " - " + nextSliceMessage;
                this.addIssueToOperationOutcome(theOperationOutcome, location, locationLine, locationCol, issueSeverity, combinedMessage, messageId);
            }
        }
        if (this.myMessages.isEmpty()) {
            String message = this.myCtx.getLocalizer().getMessage(ValidationResult.class, "noIssuesDetected", new Object[0]);
            OperationOutcomeUtil.addIssue(this.myCtx, theOperationOutcome, "information", message, null, "informational");
        }
    }

    private void addIssueToOperationOutcome(IBaseOperationOutcome theOperationOutcome, String location, Integer locationLine, Integer locationCol, ResultSeverityEnum issueSeverity, String message, String messageId) {
        if (StringUtils.isBlank((CharSequence)location) && locationLine != null && locationCol != null) {
            location = "Line[" + locationLine + "] Col[" + locationCol + "]";
        }
        String severity = issueSeverity != null ? issueSeverity.getCode() : null;
        IBase issue = OperationOutcomeUtil.addIssueWithMessageId(this.myCtx, theOperationOutcome, severity, message, messageId, (String)location, "processing");
        if (locationLine != null || locationCol != null) {
            String unknown;
            String line = unknown = UNKNOWN;
            if (locationLine != null && locationLine != -1) {
                line = locationLine.toString();
            }
            String col = unknown;
            if (locationCol != null && locationCol != -1) {
                col = locationCol.toString();
            }
            if (!unknown.equals(line) || !unknown.equals(col)) {
                OperationOutcomeUtil.addIssueLineExtensionToIssue(this.myCtx, issue, line);
                OperationOutcomeUtil.addIssueColExtensionToIssue(this.myCtx, issue, col);
                String locationString = "Line[" + line + "] Col[" + col + "]";
                OperationOutcomeUtil.addLocationToIssue(this.myCtx, issue, locationString);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)messageId)) {
            OperationOutcomeUtil.addMessageIdExtensionToIssue(this.myCtx, issue, messageId);
        }
    }

    public String toString() {
        return "ValidationResult{messageCount=" + this.myMessages.size() + ", isSuccessful=" + this.myIsSuccessful + ", description='" + this.toDescription() + "'}";
    }

    public FhirContext getContext() {
        return this.myCtx;
    }

    public int getErrorDisplayLimit() {
        return this.myErrorDisplayLimit;
    }

    public void setErrorDisplayLimit(int theErrorDisplayLimit) {
        this.myErrorDisplayLimit = theErrorDisplayLimit;
    }
}

