/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.validation;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.util.ObjectUtil;
import ca.uhn.fhir.validation.IValidationContext;
import ca.uhn.fhir.validation.SingleValidationMessage;
import ca.uhn.fhir.validation.ValidationResult;
import java.util.ArrayList;
import java.util.List;

abstract class BaseValidationContext<T>
implements IValidationContext<T> {
    protected final FhirContext myFhirContext;
    private List<SingleValidationMessage> myMessages;

    BaseValidationContext(FhirContext theFhirContext) {
        this(theFhirContext, new ArrayList<SingleValidationMessage>());
    }

    BaseValidationContext(FhirContext theFhirContext, List<SingleValidationMessage> theMessages) {
        this.myFhirContext = theFhirContext;
        this.myMessages = theMessages;
    }

    @Override
    public void addValidationMessage(SingleValidationMessage theMessage) {
        ObjectUtil.requireNonNull(theMessage, "theMessage must not be null");
        this.myMessages.add(theMessage);
    }

    @Override
    public FhirContext getFhirContext() {
        return this.myFhirContext;
    }

    @Override
    public List<SingleValidationMessage> getMessages() {
        return this.myMessages;
    }

    @Override
    public ValidationResult toResult() {
        return new ValidationResult(this.myFhirContext, this.myMessages);
    }
}

