/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SleepUtil {
    private static final Logger ourLog = LoggerFactory.getLogger(SleepUtil.class);

    public void sleepAtLeast(long theMillis) {
        this.sleepAtLeast(theMillis, true);
    }

    public void sleepAtLeast(long theMillis, boolean theLogProgress) {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() <= start + theMillis) {
            try {
                long timeSinceStarted = System.currentTimeMillis() - start;
                long timeToSleep = Math.max(0L, theMillis - timeSinceStarted);
                if (theLogProgress) {
                    ourLog.info("Sleeping for {}ms", (Object)timeToSleep);
                }
                Thread.sleep(timeToSleep);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                ourLog.error("Interrupted", (Throwable)e);
            }
        }
    }
}

