/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.i18n.Msg;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public class SearchParameterUtil {
    public static List<String> getBaseAsStrings(FhirContext theContext, IBaseResource theResource) {
        Validate.notNull((Object)theContext, (String)"theContext must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)theResource, (String)"theResource must not be null", (Object[])new Object[0]);
        RuntimeResourceDefinition def = theContext.getResourceDefinition(theResource);
        BaseRuntimeChildDefinition base = def.getChildByName("base");
        List<IBase> baseValues = base.getAccessor().getValues(theResource);
        ArrayList<String> retVal = new ArrayList<String>();
        for (IBase next : baseValues) {
            IPrimitiveType nextPrimitive = (IPrimitiveType)next;
            retVal.add(nextPrimitive.getValueAsString());
        }
        return retVal;
    }

    public static Optional<RuntimeSearchParam> getOnlyPatientSearchParamForResourceType(FhirContext theFhirContext, String theResourceType) {
        RuntimeSearchParam myPatientSearchParam = null;
        RuntimeResourceDefinition runtimeResourceDefinition = theFhirContext.getResourceDefinition(theResourceType);
        myPatientSearchParam = runtimeResourceDefinition.getSearchParam("patient");
        if (myPatientSearchParam == null && (myPatientSearchParam = runtimeResourceDefinition.getSearchParam("subject")) == null) {
            List<RuntimeSearchParam> searchParamsForCurrentVersion = runtimeResourceDefinition.getSearchParamsForCompartmentName("Patient");
            List<RuntimeSearchParam> searchParamsToUse = FhirVersionEnum.R4 == theFhirContext.getVersion().getVersion() || searchParamsForCurrentVersion.size() == 1 ? searchParamsForCurrentVersion : SearchParameterUtil.checkR4PatientCompartmentForMatchingSearchParam(runtimeResourceDefinition, theResourceType);
            myPatientSearchParam = SearchParameterUtil.validateSearchParamsAndReturnOnlyOne(runtimeResourceDefinition, searchParamsToUse);
        }
        return Optional.of(myPatientSearchParam);
    }

    @Nonnull
    private static List<RuntimeSearchParam> checkR4PatientCompartmentForMatchingSearchParam(RuntimeResourceDefinition theRuntimeResourceDefinition, String theResourceType) {
        RuntimeSearchParam patientSearchParamForR4 = FhirContext.forR4Cached().getResourceDefinition(theResourceType).getSearchParam("patient");
        return Optional.ofNullable(patientSearchParamForR4).map(patientSearchParamForR4NonNull -> theRuntimeResourceDefinition.getSearchParamsForCompartmentName("Patient").stream().filter(searchParam -> searchParam.getPath() != null).filter(searchParam -> searchParam.getPath().equals(patientSearchParamForR4NonNull.getPath())).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    public static Set<String> getPatientSearchParamsForResourceType(FhirContext theFhirContext, String theResourceType) {
        RuntimeSearchParam mySubjectSearchParam;
        RuntimeResourceDefinition runtimeResourceDefinition = theFhirContext.getResourceDefinition(theResourceType);
        ArrayList<RuntimeSearchParam> searchParams = new ArrayList<RuntimeSearchParam>(runtimeResourceDefinition.getSearchParamsForCompartmentName("Patient"));
        RuntimeSearchParam myPatientSearchParam = runtimeResourceDefinition.getSearchParam("patient");
        if (myPatientSearchParam != null) {
            searchParams.add(myPatientSearchParam);
        }
        if ((mySubjectSearchParam = runtimeResourceDefinition.getSearchParam("subject")) != null) {
            searchParams.add(mySubjectSearchParam);
        }
        if (CollectionUtils.isEmpty(searchParams)) {
            String errorMessage = String.format("Resource type [%s] is not eligible for this type of export, as it contains no Patient compartment, and no `patient` or `subject` search parameter", runtimeResourceDefinition.getId());
            throw new IllegalArgumentException(Msg.code(2222) + errorMessage);
        }
        return searchParams.stream().map(RuntimeSearchParam::getName).collect(Collectors.toSet());
    }

    public static RuntimeSearchParam getOnlyPatientCompartmentRuntimeSearchParam(FhirContext theFhirContext, String theResourceType) {
        RuntimeResourceDefinition resourceDefinition = theFhirContext.getResourceDefinition(theResourceType);
        return SearchParameterUtil.getOnlyPatientCompartmentRuntimeSearchParam(resourceDefinition);
    }

    public static RuntimeSearchParam getOnlyPatientCompartmentRuntimeSearchParam(RuntimeResourceDefinition runtimeResourceDefinition) {
        return SearchParameterUtil.validateSearchParamsAndReturnOnlyOne(runtimeResourceDefinition, runtimeResourceDefinition.getSearchParamsForCompartmentName("Patient"));
    }

    public static RuntimeSearchParam getOnlyPatientCompartmentRuntimeSearchParam(RuntimeResourceDefinition runtimeResourceDefinition, List<RuntimeSearchParam> theSearchParams) {
        return SearchParameterUtil.validateSearchParamsAndReturnOnlyOne(runtimeResourceDefinition, theSearchParams);
    }

    @Nonnull
    private static RuntimeSearchParam validateSearchParamsAndReturnOnlyOne(RuntimeResourceDefinition theRuntimeResourceDefinition, List<RuntimeSearchParam> theSearchParams) {
        if (CollectionUtils.isEmpty(theSearchParams)) {
            String errorMessage = String.format("Resource type [%s] for ID [%s] and version: [%s] is not eligible for this type of export, as it contains no Patient compartment, and no `patient` or `subject` search parameter", new Object[]{theRuntimeResourceDefinition.getName(), theRuntimeResourceDefinition.getId(), theRuntimeResourceDefinition.getStructureVersion()});
            throw new IllegalArgumentException(Msg.code(1774) + errorMessage);
        }
        if (theSearchParams.size() != 1) {
            String errorMessage = String.format("Resource type [%s] for ID [%s] and version: [%s] has more than one Search Param which references a patient compartment. We are unable to disambiguate which patient search parameter we should be searching by.", new Object[]{theRuntimeResourceDefinition.getName(), theRuntimeResourceDefinition.getId(), theRuntimeResourceDefinition.getStructureVersion()});
            throw new IllegalArgumentException(Msg.code(1775) + errorMessage);
        }
        RuntimeSearchParam patientSearchParam = theSearchParams.get(0);
        return patientSearchParam;
    }

    public static List<RuntimeSearchParam> getAllPatientCompartmentRuntimeSearchParamsForResourceType(FhirContext theFhirContext, String theResourceType) {
        RuntimeResourceDefinition runtimeResourceDefinition = theFhirContext.getResourceDefinition(theResourceType);
        return SearchParameterUtil.getAllPatientCompartmentRuntimeSearchParams(runtimeResourceDefinition);
    }

    public static List<RuntimeSearchParam> getAllPatientCompartmenRuntimeSearchParams(FhirContext theFhirContext) {
        return theFhirContext.getResourceTypes().stream().flatMap(type -> SearchParameterUtil.getAllPatientCompartmentRuntimeSearchParamsForResourceType(theFhirContext, type).stream()).collect(Collectors.toList());
    }

    public static Set<String> getAllResourceTypesThatAreInPatientCompartment(FhirContext theFhirContext) {
        return theFhirContext.getResourceTypes().stream().filter(type -> CollectionUtils.isNotEmpty(SearchParameterUtil.getAllPatientCompartmentRuntimeSearchParamsForResourceType(theFhirContext, type))).collect(Collectors.toSet());
    }

    private static List<RuntimeSearchParam> getAllPatientCompartmentRuntimeSearchParams(RuntimeResourceDefinition theRuntimeResourceDefinition) {
        List<RuntimeSearchParam> patient = theRuntimeResourceDefinition.getSearchParamsForCompartmentName("Patient");
        return patient;
    }

    public static boolean isResourceTypeInPatientCompartment(FhirContext theFhirContext, String theResourceType) {
        RuntimeResourceDefinition runtimeResourceDefinition = theFhirContext.getResourceDefinition(theResourceType);
        return CollectionUtils.isNotEmpty(SearchParameterUtil.getAllPatientCompartmentRuntimeSearchParams(runtimeResourceDefinition));
    }

    @Nullable
    public static String getCode(FhirContext theContext, IBaseResource theResource) {
        return SearchParameterUtil.getStringChild(theContext, theResource, "code");
    }

    @Nullable
    public static String getURL(FhirContext theContext, IBaseResource theResource) {
        return SearchParameterUtil.getStringChild(theContext, theResource, "url");
    }

    @Nullable
    public static String getExpression(FhirContext theFhirContext, IBaseResource theResource) {
        return SearchParameterUtil.getStringChild(theFhirContext, theResource, "expression");
    }

    private static String getStringChild(FhirContext theFhirContext, IBaseResource theResource, String theChildName) {
        Validate.notNull((Object)theFhirContext, (String)"theContext must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)theResource, (String)"theResource must not be null", (Object[])new Object[0]);
        RuntimeResourceDefinition def = theFhirContext.getResourceDefinition(theResource);
        BaseRuntimeChildDefinition base = def.getChildByName(theChildName);
        return base.getAccessor().getFirstValueOrNull(theResource).map(t -> (IPrimitiveType)t).map(t -> t.getValueAsString()).orElse(null);
    }

    public static String stripModifier(String theSearchParam) {
        int colonIndex = theSearchParam.indexOf(":");
        String retval = colonIndex == -1 ? theSearchParam : theSearchParam.substring(0, colonIndex);
        return retval;
    }
}

