/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.commons.lang3.Validate;

public class ProxyUtil {
    private ProxyUtil() {
    }

    public static <T> T synchronizedProxy(Class<T> theClass, T theInstance) {
        Validate.isTrue((boolean)theClass.isInterface(), (String)"%s is not an interface", (Object[])new Object[]{theClass});
        SynchronizedHandler handler = new SynchronizedHandler(theInstance);
        Object object = Proxy.newProxyInstance(theClass.getClassLoader(), new Class[]{theClass}, (InvocationHandler)handler);
        return theClass.cast(object);
    }

    static class SynchronizedHandler
    implements InvocationHandler {
        private final Object theDelegate;

        SynchronizedHandler(Object theDelegate) {
            this.theDelegate = theDelegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object object = this.theDelegate;
            synchronized (object) {
                return method.invoke(this.theDelegate, args);
            }
        }
    }
}

