/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.model.api.IModelJson;
import ca.uhn.fhir.model.api.annotation.SensitiveNoDisplay;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.PropertyWriter;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;

public class JsonUtil {
    private static final ObjectMapper ourMapperPrettyPrint;
    private static final ObjectMapper ourMapperNonPrettyPrint;
    private static final ObjectMapper ourMapperIncludeSensitive;
    public static final SimpleBeanPropertyFilter SIMPLE_BEAN_PROPERTY_FILTER;
    public static final SimpleFilterProvider SENSITIVE_DATA_FILTER_PROVIDER;
    public static final SimpleFilterProvider SHOW_ALL_DATA_FILTER_PROVIDER;

    public static <T> T deserialize(@Nonnull String theInput, @Nonnull Class<T> theType) {
        try {
            return (T)ourMapperPrettyPrint.readerFor(theType).readValue(theInput);
        }
        catch (IOException e) {
            throw new InternalErrorException(Msg.code(2060) + e);
        }
    }

    public static <T> List<T> deserializeList(@Nonnull String theInput, @Nonnull Class<T> theType) throws IOException {
        return (List)ourMapperPrettyPrint.readerForListOf(theType).readValue(theInput);
    }

    public static <T> T deserialize(@Nonnull InputStream theInput, @Nonnull Class<T> theType) throws IOException {
        return (T)ourMapperPrettyPrint.readerFor(theType).readValue(theInput);
    }

    public static String serializeWithSensitiveData(@Nonnull IModelJson theInput) {
        try {
            return ourMapperIncludeSensitive.writeValueAsString((Object)theInput);
        }
        catch (JsonProcessingException e) {
            throw new InvalidRequestException(Msg.code(2487) + "Failed to encode " + theInput.getClass(), (Throwable)e);
        }
    }

    public static String serialize(@Nonnull Object theInput) {
        return JsonUtil.serialize(theInput, true);
    }

    public static String serialize(@Nonnull Object theInput, boolean thePrettyPrint) {
        try {
            StringWriter sw = new StringWriter();
            if (thePrettyPrint) {
                ourMapperPrettyPrint.writeValue((Writer)sw, theInput);
            } else {
                ourMapperNonPrettyPrint.writeValue((Writer)sw, theInput);
            }
            return sw.toString();
        }
        catch (IOException e) {
            throw new InternalErrorException(Msg.code(2061) + e);
        }
    }

    public FilterProvider getSensitiveDataFilterProvider() {
        return SENSITIVE_DATA_FILTER_PROVIDER;
    }

    public static void serialize(@Nonnull Object theInput, @Nonnull Writer theWriter) throws IOException {
        theWriter.append(JsonUtil.serialize(theInput));
    }

    public static String serializeOrInvalidRequest(IModelJson theJson) {
        try {
            return ourMapperNonPrettyPrint.writeValueAsString((Object)theJson);
        }
        catch (JsonProcessingException e) {
            throw new InvalidRequestException(Msg.code(1741) + "Failed to encode " + theJson.getClass(), (Throwable)e);
        }
    }

    static {
        SIMPLE_BEAN_PROPERTY_FILTER = new SensitiveDataFilter();
        SENSITIVE_DATA_FILTER_PROVIDER = new SimpleFilterProvider().addFilter("sensitiveDataFilter", SIMPLE_BEAN_PROPERTY_FILTER);
        SHOW_ALL_DATA_FILTER_PROVIDER = new SimpleFilterProvider().addFilter("sensitiveDataFilter", SimpleBeanPropertyFilter.serializeAll());
        ourMapperPrettyPrint = new ObjectMapper();
        ourMapperPrettyPrint.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        ourMapperPrettyPrint.setFilterProvider((FilterProvider)SENSITIVE_DATA_FILTER_PROVIDER);
        ourMapperPrettyPrint.enable(SerializationFeature.INDENT_OUTPUT);
        ourMapperPrettyPrint.registerModule((Module)new JavaTimeModule());
        ourMapperNonPrettyPrint = new ObjectMapper();
        ourMapperNonPrettyPrint.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        ourMapperNonPrettyPrint.setFilterProvider((FilterProvider)SENSITIVE_DATA_FILTER_PROVIDER);
        ourMapperNonPrettyPrint.disable(SerializationFeature.INDENT_OUTPUT);
        ourMapperNonPrettyPrint.registerModule((Module)new JavaTimeModule());
        ourMapperIncludeSensitive = new ObjectMapper();
        ourMapperIncludeSensitive.setFilterProvider((FilterProvider)SHOW_ALL_DATA_FILTER_PROVIDER);
        ourMapperIncludeSensitive.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        ourMapperIncludeSensitive.disable(SerializationFeature.INDENT_OUTPUT);
        ourMapperIncludeSensitive.registerModule((Module)new JavaTimeModule());
    }

    private static class SensitiveDataFilter
    extends SimpleBeanPropertyFilter {
        private SensitiveDataFilter() {
        }

        protected boolean include(PropertyWriter writer) {
            return true;
        }

        public void serializeAsField(Object pojo, JsonGenerator gen, SerializerProvider provider, PropertyWriter writer) throws Exception {
            if (this.include(writer) && !this.isFieldSensitive(writer)) {
                super.serializeAsField(pojo, gen, provider, writer);
            }
        }

        private boolean isFieldSensitive(PropertyWriter writer) {
            return writer.getAnnotation(SensitiveNoDisplay.class) != null;
        }
    }
}

