/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;

public class CollectionUtil {
    private CollectionUtil() {
    }

    @Nonnull
    public static <T> Collection<T> nullSafeUnion(@Nullable Collection<T> theCollection0, @Nullable Collection<T> theCollection1) {
        Collection<T> collection1;
        Collection<T> collection0 = theCollection0;
        if (collection0 != null && collection0.isEmpty()) {
            collection0 = null;
        }
        if ((collection1 = theCollection1) != null && collection1.isEmpty()) {
            collection1 = null;
        }
        if (collection0 == null && collection1 == null) {
            return Collections.emptySet();
        }
        if (collection0 == null) {
            return Collections.unmodifiableCollection(collection1);
        }
        if (collection1 == null) {
            return Collections.unmodifiableCollection(collection0);
        }
        return CollectionUtils.union(collection0, collection1);
    }

    public static <T> Set<T> newSet(T ... theValues) {
        HashSet retVal = new HashSet();
        Collections.addAll(retVal, theValues);
        return Collections.unmodifiableSet(retVal);
    }
}

