/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.api;

import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheControlDirective {
    private static final String MAX_RESULTS_EQUALS = "max-results=";
    private static final Logger ourLog = LoggerFactory.getLogger(CacheControlDirective.class);
    private boolean myNoCache;
    private boolean myNoStore;
    private Integer myMaxResults;

    public Integer getMaxResults() {
        return this.myMaxResults;
    }

    public CacheControlDirective setMaxResults(Integer theMaxResults) {
        this.myMaxResults = theMaxResults;
        return this;
    }

    public boolean isNoCache() {
        return this.myNoCache;
    }

    public CacheControlDirective setNoCache(boolean theNoCache) {
        this.myNoCache = theNoCache;
        return this;
    }

    public boolean isNoStore() {
        return this.myNoStore;
    }

    public CacheControlDirective setNoStore(boolean theNoStore) {
        this.myNoStore = theNoStore;
        return this;
    }

    public CacheControlDirective parse(List<String> theValues) {
        if (theValues != null) {
            for (String nextValue : theValues) {
                StringTokenizer tok = new StringTokenizer(nextValue, ",");
                while (tok.hasMoreTokens()) {
                    String next = StringUtils.trim((String)tok.nextToken());
                    if ("no-cache".equals(next)) {
                        this.myNoCache = true;
                        continue;
                    }
                    if ("no-store".equals(next)) {
                        this.myNoStore = true;
                        continue;
                    }
                    if (!next.startsWith(MAX_RESULTS_EQUALS)) continue;
                    String valueString = StringUtils.trim((String)next.substring(MAX_RESULTS_EQUALS.length()));
                    try {
                        this.myMaxResults = Integer.parseInt(valueString);
                    }
                    catch (NumberFormatException e) {
                        ourLog.warn("Invalid {} value: {}", (Object)"max-results", (Object)valueString);
                    }
                }
            }
        }
        return this;
    }

    public static CacheControlDirective noCache() {
        return new CacheControlDirective().setNoCache(true);
    }
}

