/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.context.support;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.support.DefaultProfileValidationSupportBundleStrategy;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.util.ILockable;
import ca.uhn.fhir.util.ReflectionUtil;
import jakarta.annotation.Nullable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public class DefaultProfileValidationSupport
implements IValidationSupport {
    private static final Map<FhirVersionEnum, IValidationSupport> ourImplementations = Collections.synchronizedMap(new HashMap());
    private final FhirContext myCtx;
    private final IValidationSupport myDelegate;
    private final Runnable myFlush;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultProfileValidationSupport(FhirContext theFhirContext) {
        IValidationSupport strategy;
        this.myCtx = theFhirContext;
        Map<FhirVersionEnum, IValidationSupport> map = ourImplementations;
        synchronized (map) {
            strategy = ourImplementations.get((Object)theFhirContext.getVersion().getVersion());
            if (strategy == null) {
                if (theFhirContext.getVersion().getVersion().isEqualOrNewerThan(FhirVersionEnum.R5)) {
                    strategy = ReflectionUtil.newInstance("org.hl7.fhir.common.hapi.validation.support.DefaultProfileValidationSupportNpmStrategy", IValidationSupport.class, new Class[]{FhirContext.class}, new Object[]{theFhirContext});
                    ((ILockable)((Object)strategy)).lock();
                } else {
                    strategy = new DefaultProfileValidationSupportBundleStrategy(theFhirContext);
                }
                ourImplementations.put(theFhirContext.getVersion().getVersion(), strategy);
            }
        }
        this.myDelegate = strategy;
        this.myFlush = this.myDelegate instanceof DefaultProfileValidationSupportBundleStrategy ? () -> ((DefaultProfileValidationSupportBundleStrategy)this.myDelegate).flush() : () -> {};
    }

    @Override
    public String getName() {
        return this.myCtx.getVersion().getVersion() + " FHIR Standard Profile Validation Support";
    }

    @Override
    public List<IBaseResource> fetchAllConformanceResources() {
        return this.myDelegate.fetchAllConformanceResources();
    }

    @Override
    public <T extends IBaseResource> List<T> fetchAllStructureDefinitions() {
        return this.myDelegate.fetchAllStructureDefinitions();
    }

    @Override
    @Nullable
    public <T extends IBaseResource> List<T> fetchAllNonBaseStructureDefinitions() {
        return this.myDelegate.fetchAllNonBaseStructureDefinitions();
    }

    @Override
    public IBaseResource fetchCodeSystem(String theSystem) {
        return this.myDelegate.fetchCodeSystem(theSystem);
    }

    @Override
    public IBaseResource fetchStructureDefinition(String theUrl) {
        return this.myDelegate.fetchStructureDefinition(theUrl);
    }

    @Override
    public IBaseResource fetchValueSet(String theUrl) {
        return this.myDelegate.fetchValueSet(theUrl);
    }

    public void flush() {
        this.myFlush.run();
    }

    @Override
    public FhirContext getFhirContext() {
        return this.myCtx;
    }

    @Nullable
    public static String getConformanceResourceUrl(FhirContext theFhirContext, IBaseResource theResource) {
        String urlValueString = null;
        Optional urlValue = theFhirContext.getResourceDefinition(theResource).getChildByName("url").getAccessor().getFirstValueOrNull(theResource);
        if (urlValue.isPresent()) {
            IPrimitiveType urlValueType = (IPrimitiveType)urlValue.get();
            urlValueString = urlValueType.getValueAsString();
        }
        return urlValueString;
    }
}

