/*
 * #%L
 * HAPI FHIR - Core Library
 * %%
 * Copyright (C) 2014 - 2024 Smile CDR, Inc.
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */
package ca.uhn.fhir.context;

import org.hl7.fhir.instance.model.api.IBaseResource;

/**
 * HL7org structures use a List for contained instead of a distinct datatype
 */
public class RuntimeElemContainedResourceList extends BaseRuntimeElementDefinition<IBaseResource> {

	public RuntimeElemContainedResourceList(Class<IBaseResource> theClass, boolean theStandardType) {
		super("contained", theClass, theStandardType);
	}

	@Override
	public ca.uhn.fhir.context.BaseRuntimeElementDefinition.ChildTypeEnum getChildType() {
		return ChildTypeEnum.CONTAINED_RESOURCE_LIST;
	}
}
