/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util.rdf;

import ca.uhn.fhir.util.rdf.StreamRDFDedup;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import org.apache.jena.atlas.io.AWriter;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.system.RiotLib;
import org.apache.jena.riot.system.StreamOps;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.writer.WriterStreamRDFBlocks;
import org.apache.jena.riot.writer.WriterStreamRDFPlain;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;
import org.apache.jena.vocabulary.RDF;

public class StreamingRDFWriter {
    private final OutputStream out;
    private final Iterator<Triple> triples;
    private int dedupWindowSize = 10000;

    public StreamingRDFWriter(OutputStream out, Iterator<Triple> triples) {
        this.out = out;
        this.triples = triples;
    }

    public void setDedupWindowSize(int newSize) {
        this.dedupWindowSize = newSize;
    }

    public void writeNTriples() {
        Object writer = new WriterStreamRDFPlain((AWriter)new IndentedWriter(this.out));
        if (this.dedupWindowSize > 0) {
            writer = new StreamRDFDedup((StreamRDF)writer, this.dedupWindowSize);
        }
        writer.start();
        StreamOps.sendTriplesToStream(this.triples, (StreamRDF)writer);
        writer.finish();
    }

    public void writeTurtle(String baseIRI, PrefixMapping prefixes, boolean writeBase) {
        prefixes = this.ensureRDFPrefix(prefixes);
        if (writeBase) {
            IndentedWriter w = new IndentedWriter(this.out);
            RiotLib.writeBase((IndentedWriter)w, (String)baseIRI);
            w.flush();
        }
        Object writer = new WriterStreamRDFBlocks(this.out);
        if (this.dedupWindowSize > 0) {
            writer = new StreamRDFDedup((StreamRDF)writer, this.dedupWindowSize);
        }
        writer.start();
        writer.base(baseIRI);
        for (Map.Entry e : prefixes.getNsPrefixMap().entrySet()) {
            writer.prefix((String)e.getKey(), (String)e.getValue());
        }
        StreamOps.sendTriplesToStream(this.triples, (StreamRDF)writer);
        writer.finish();
    }

    private PrefixMapping ensureRDFPrefix(PrefixMapping prefixes) {
        if (prefixes.getNsURIPrefix(RDF.getURI()) != null) {
            return prefixes;
        }
        if (prefixes.getNsPrefixURI("rdf") != null) {
            return prefixes;
        }
        PrefixMappingImpl newPrefixes = new PrefixMappingImpl();
        newPrefixes.setNsPrefixes(prefixes);
        newPrefixes.setNsPrefix("rdf", RDF.getURI());
        return newPrefixes;
    }
}

