/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.thymeleaf.util.Validate;

public class TransactionBuilder {
    private final FhirContext myContext;
    private final IBaseBundle myBundle;
    private final RuntimeResourceDefinition myBundleDef;
    private final BaseRuntimeChildDefinition myEntryChild;
    private final BaseRuntimeElementDefinition<?> myEntryDef;
    private final BaseRuntimeChildDefinition myEntryResourceChild;
    private final BaseRuntimeChildDefinition myEntryFullUrlChild;
    private final BaseRuntimeChildDefinition myEntryRequestChild;
    private final BaseRuntimeElementDefinition<?> myEntryRequestDef;
    private final BaseRuntimeChildDefinition myEntryRequestUrlChild;
    private final BaseRuntimeChildDefinition myEntryRequestMethodChild;
    private final BaseRuntimeElementDefinition<?> myEntryRequestMethodDef;

    public TransactionBuilder(FhirContext theContext) {
        this.myContext = theContext;
        this.myBundleDef = this.myContext.getResourceDefinition("Bundle");
        this.myBundle = (IBaseBundle)this.myBundleDef.newInstance();
        BaseRuntimeChildDefinition typeChild = this.myBundleDef.getChildByName("type");
        IPrimitiveType type = (IPrimitiveType)typeChild.getChildByName("type").newInstance(typeChild.getInstanceConstructorArguments());
        type.setValueAsString("transaction");
        typeChild.getMutator().setValue(this.myBundle, type);
        this.myEntryChild = this.myBundleDef.getChildByName("entry");
        this.myEntryDef = this.myEntryChild.getChildByName("entry");
        this.myEntryResourceChild = this.myEntryDef.getChildByName("resource");
        this.myEntryFullUrlChild = this.myEntryDef.getChildByName("fullUrl");
        this.myEntryRequestChild = this.myEntryDef.getChildByName("request");
        this.myEntryRequestDef = this.myEntryRequestChild.getChildByName("request");
        this.myEntryRequestUrlChild = this.myEntryRequestDef.getChildByName("url");
        this.myEntryRequestMethodChild = this.myEntryRequestDef.getChildByName("method");
        this.myEntryRequestMethodDef = this.myEntryRequestMethodChild.getChildByName("method");
    }

    public TransactionBuilder addUpdateEntry(IBaseResource theResource) {
        Validate.notNull((Object)theResource, (String)"theResource must not be null");
        Validate.notEmpty((String)theResource.getIdElement().getValue(), (String)"theResource must have an ID");
        Object entry = this.myEntryDef.newInstance();
        this.myEntryChild.getMutator().addValue(this.myBundle, (IBase)entry);
        IPrimitiveType fullUrl = (IPrimitiveType)this.myContext.getElementDefinition("uri").newInstance();
        fullUrl.setValueAsString(theResource.getIdElement().getValue());
        this.myEntryFullUrlChild.getMutator().setValue((IBase)entry, fullUrl);
        this.myEntryResourceChild.getMutator().setValue((IBase)entry, theResource);
        Object request = this.myEntryRequestDef.newInstance();
        this.myEntryRequestChild.getMutator().setValue((IBase)entry, (IBase)request);
        IPrimitiveType url = (IPrimitiveType)this.myContext.getElementDefinition("uri").newInstance();
        url.setValueAsString(theResource.getIdElement().toUnqualifiedVersionless().getValue());
        this.myEntryRequestUrlChild.getMutator().setValue((IBase)request, url);
        IPrimitiveType method = (IPrimitiveType)this.myEntryRequestMethodDef.newInstance(this.myEntryRequestMethodChild.getInstanceConstructorArguments());
        method.setValueAsString("PUT");
        this.myEntryRequestMethodChild.getMutator().setValue((IBase)request, method);
        return this;
    }

    public IBaseBundle getBundle() {
        return this.myBundle;
    }
}

