/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.annotation.Nonnull;

public class JsonUtil {
    private static final ObjectMapper ourMapperPrettyPrint = new ObjectMapper();
    private static final ObjectMapper ourMapperNonPrettyPrint;

    public static <T> T deserialize(@Nonnull String theInput, @Nonnull Class<T> theType) throws IOException {
        return (T)ourMapperPrettyPrint.readerFor(theType).readValue(theInput);
    }

    public static String serialize(@Nonnull Object theInput) throws IOException {
        return JsonUtil.serialize(theInput, true);
    }

    public static String serialize(@Nonnull Object theInput, boolean thePrettyPrint) throws IOException {
        StringWriter sw = new StringWriter();
        if (thePrettyPrint) {
            ourMapperPrettyPrint.writeValue((Writer)sw, theInput);
        } else {
            ourMapperNonPrettyPrint.writeValue((Writer)sw, theInput);
        }
        return sw.toString();
    }

    public static void serialize(@Nonnull Object theInput, @Nonnull Writer theWriter) throws IOException {
        theWriter.append(JsonUtil.serialize(theInput));
    }

    static {
        ourMapperPrettyPrint.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        ourMapperPrettyPrint.enable(SerializationFeature.INDENT_OUTPUT);
        ourMapperNonPrettyPrint = new ObjectMapper();
        ourMapperNonPrettyPrint.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        ourMapperNonPrettyPrint.disable(SerializationFeature.INDENT_OUTPUT);
    }
}

