/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.param;

import ca.uhn.fhir.model.base.composite.BaseCodingDt;
import ca.uhn.fhir.model.base.composite.BaseIdentifierDt;
import ca.uhn.fhir.rest.param.BaseOrListParam;
import ca.uhn.fhir.rest.param.InternalCodingDt;
import ca.uhn.fhir.rest.param.TokenParam;
import ca.uhn.fhir.util.CoverageIgnore;
import java.util.ArrayList;
import java.util.List;

public class TokenOrListParam
extends BaseOrListParam<TokenOrListParam, TokenParam> {
    public TokenOrListParam() {
    }

    public TokenOrListParam(String theSystem, String ... theValues) {
        for (String next : theValues) {
            this.add(theSystem, next);
        }
    }

    @Override
    public void add(BaseCodingDt theCodingDt) {
        this.add(new TokenParam(theCodingDt));
    }

    @Override
    public void add(BaseIdentifierDt theIdentifierDt) {
        this.add(new TokenParam(theIdentifierDt));
    }

    public TokenOrListParam add(String theSystem, String theValue) {
        this.add(new TokenParam(theSystem, theValue));
        return this;
    }

    @Override
    public TokenOrListParam add(String theValue) {
        this.add(new TokenParam(null, theValue));
        return this;
    }

    public List<BaseCodingDt> getListAsCodings() {
        ArrayList<BaseCodingDt> retVal = new ArrayList<BaseCodingDt>();
        for (TokenParam next : this.getValuesAsQueryTokens()) {
            InternalCodingDt nextCoding = next.getValueAsCoding();
            if (nextCoding.isEmpty()) continue;
            retVal.add(nextCoding);
        }
        return retVal;
    }

    @Override
    @CoverageIgnore
    TokenParam newInstance() {
        return new TokenParam();
    }

    public boolean doesCodingListMatch(List<? extends BaseCodingDt> theCodings) {
        List<BaseCodingDt> paramCodings = this.getListAsCodings();
        for (BaseCodingDt baseCodingDt : theCodings) {
            for (BaseCodingDt paramCoding : paramCodings) {
                if (!baseCodingDt.matchesToken(paramCoding)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    @CoverageIgnore
    public TokenOrListParam addOr(TokenParam theParameter) {
        this.add(theParameter);
        return this;
    }
}

