/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.primitive;

import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.SimpleSetter;
import ca.uhn.fhir.model.primitive.BaseDateTimeDt;
import java.util.Date;
import java.util.TimeZone;

@DatatypeDef(name="dateTime")
public class DateTimeDt
extends BaseDateTimeDt {
    public static final TemporalPrecisionEnum DEFAULT_PRECISION = TemporalPrecisionEnum.SECOND;

    public DateTimeDt() {
    }

    @SimpleSetter(suffix="WithSecondsPrecision")
    public DateTimeDt(@SimpleSetter.Parameter(name="theDate") Date theDate) {
        super(theDate, DEFAULT_PRECISION, TimeZone.getDefault());
    }

    @SimpleSetter
    public DateTimeDt(@SimpleSetter.Parameter(name="theDate") Date theDate, @SimpleSetter.Parameter(name="thePrecision") TemporalPrecisionEnum thePrecision) {
        super(theDate, thePrecision, TimeZone.getDefault());
    }

    public DateTimeDt(String theValue) {
        super(theValue);
    }

    public DateTimeDt(Date theDate, TemporalPrecisionEnum thePrecision, TimeZone theTimezone) {
        super(theDate, thePrecision, theTimezone);
    }

    @Override
    protected boolean isPrecisionAllowed(TemporalPrecisionEnum thePrecision) {
        switch (thePrecision) {
            case YEAR: 
            case MONTH: 
            case DAY: 
            case SECOND: 
            case MILLI: {
                return true;
            }
        }
        return false;
    }

    public static DateTimeDt withCurrentTime() {
        return new DateTimeDt(new Date(), TemporalPrecisionEnum.SECOND, TimeZone.getDefault());
    }

    @Override
    protected TemporalPrecisionEnum getDefaultPrecisionForDatatype() {
        return DEFAULT_PRECISION;
    }
}

