/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.util.CoverageIgnore;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CoverageIgnore
public class PortUtil {
    private static final Logger ourLog = LoggerFactory.getLogger(PortUtil.class);

    private PortUtil() {
    }

    public static int findFreePort() {
        try {
            Socket client;
            int i;
            ServerSocket server = new ServerSocket(0);
            server.setReuseAddress(true);
            int port = server.getLocalPort();
            for (i = 0; i < 10; ++i) {
                try {
                    client = new Socket();
                    client.connect(new InetSocketAddress(port), 1000);
                    break;
                }
                catch (Exception e) {
                    if (i == 9) {
                        throw new InternalErrorException("Can not connect to port: " + port);
                    }
                    Thread.sleep(250L);
                    continue;
                }
            }
            server.close();
            for (i = 0; i < 10; ++i) {
                try {
                    client = new Socket();
                    client.connect(new InetSocketAddress(port), 1000);
                    ourLog.info("Socket still seems open");
                    Thread.sleep(250L);
                    continue;
                }
                catch (Exception e) {
                    break;
                }
            }
            Thread.sleep(500L);
            StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
            StackTraceElement previousElement = stackTraceElements[2];
            ourLog.info("Returned available port {} for: {}", (Object)port, (Object)previousElement.toString());
            return port;
        }
        catch (IOException | InterruptedException e) {
            throw new Error(e);
        }
    }
}

