/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.exceptions;

import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.base.composite.BaseIdentifierDt;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.util.CoverageIgnore;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.hl7.fhir.instance.model.api.IIdType;

@CoverageIgnore
public class ResourceNotFoundException
extends BaseServerResponseException {
    private static final long serialVersionUID = 1L;
    public static final int STATUS_CODE = 404;

    public ResourceNotFoundException(Class<? extends IResource> theClass, IdDt theId) {
        super(404, ResourceNotFoundException.createErrorMessage(theClass, theId));
    }

    public ResourceNotFoundException(Class<? extends IResource> theClass, IdDt theId, IBaseOperationOutcome theOperationOutcome) {
        super(404, ResourceNotFoundException.createErrorMessage(theClass, theId), theOperationOutcome);
    }

    public ResourceNotFoundException(Class<? extends IResource> theClass, IIdType theId) {
        super(404, ResourceNotFoundException.createErrorMessage(theClass, theId));
    }

    public ResourceNotFoundException(Class<? extends IResource> theClass, IIdType theId, IBaseOperationOutcome theOperationOutcome) {
        super(404, ResourceNotFoundException.createErrorMessage(theClass, theId), theOperationOutcome);
    }

    public ResourceNotFoundException(String theMessage, IBaseOperationOutcome theOperationOutcome) {
        super(404, theMessage, theOperationOutcome);
    }

    @Deprecated
    public ResourceNotFoundException(Class<? extends IResource> theClass, BaseIdentifierDt theId) {
        super(404, "Resource of type " + theClass.getSimpleName() + " with ID " + theId + " is not known");
    }

    public ResourceNotFoundException(IdDt theId) {
        super(404, ResourceNotFoundException.createErrorMessage(theId));
    }

    public ResourceNotFoundException(IIdType theId) {
        super(404, ResourceNotFoundException.createErrorMessage(theId));
    }

    public ResourceNotFoundException(IIdType theId, IBaseOperationOutcome theOperationOutcome) {
        super(404, ResourceNotFoundException.createErrorMessage(theId), theOperationOutcome);
    }

    public ResourceNotFoundException(String theMessage) {
        super(404, theMessage);
    }

    private static String createErrorMessage(Class<? extends IResource> theClass, IIdType theId) {
        return "Resource of type " + theClass.getSimpleName() + " with ID " + theId + " is not known";
    }

    private static String createErrorMessage(IIdType theId) {
        return "Resource " + (theId != null ? theId.getValue() : "") + " is not known";
    }
}

