/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.parser.json;

import ca.uhn.fhir.parser.json.JsonLikeArray;
import ca.uhn.fhir.parser.json.JsonLikeObject;

public abstract class JsonLikeValue {
    public static final JsonLikeValue NULL = new JsonLikeValue(){

        @Override
        public ValueType getJsonType() {
            return ValueType.NULL;
        }

        @Override
        public ScalarType getDataType() {
            return null;
        }

        @Override
        public Object getValue() {
            return null;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof JsonLikeValue) {
                return this.getJsonType().equals((Object)((JsonLikeValue)obj).getJsonType());
            }
            return false;
        }

        public int hashCode() {
            return "null".hashCode();
        }

        public String toString() {
            return "null";
        }
    };
    public static final JsonLikeValue TRUE = new JsonLikeValue(){

        @Override
        public ValueType getJsonType() {
            return ValueType.SCALAR;
        }

        @Override
        public ScalarType getDataType() {
            return ScalarType.BOOLEAN;
        }

        @Override
        public Object getValue() {
            return Boolean.TRUE;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof JsonLikeValue) {
                return this.getJsonType().equals((Object)((JsonLikeValue)obj).getJsonType()) && this.getDataType().equals((Object)((JsonLikeValue)obj).getDataType()) && this.toString().equals(((JsonLikeValue)obj).toString());
            }
            return false;
        }

        public int hashCode() {
            return "true".hashCode();
        }

        public String toString() {
            return "true";
        }
    };
    public static final JsonLikeValue FALSE = new JsonLikeValue(){

        @Override
        public ValueType getJsonType() {
            return ValueType.SCALAR;
        }

        @Override
        public ScalarType getDataType() {
            return ScalarType.BOOLEAN;
        }

        @Override
        public Object getValue() {
            return Boolean.FALSE;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof JsonLikeValue) {
                return this.getJsonType().equals((Object)((JsonLikeValue)obj).getJsonType()) && this.getDataType().equals((Object)((JsonLikeValue)obj).getDataType()) && this.toString().equals(((JsonLikeValue)obj).toString());
            }
            return false;
        }

        public int hashCode() {
            return "false".hashCode();
        }

        public String toString() {
            return "false";
        }
    };

    public abstract ValueType getJsonType();

    public abstract ScalarType getDataType();

    public abstract Object getValue();

    public boolean isArray() {
        return this.getJsonType() == ValueType.ARRAY;
    }

    public boolean isObject() {
        return this.getJsonType() == ValueType.OBJECT;
    }

    public boolean isScalar() {
        return this.getJsonType() == ValueType.SCALAR;
    }

    public boolean isString() {
        return this.getJsonType() == ValueType.SCALAR && this.getDataType() == ScalarType.STRING;
    }

    public boolean isNumber() {
        return this.getJsonType() == ValueType.SCALAR && this.getDataType() == ScalarType.NUMBER;
    }

    public boolean isNull() {
        return this.getJsonType() == ValueType.NULL;
    }

    public JsonLikeArray getAsArray() {
        return null;
    }

    public JsonLikeObject getAsObject() {
        return null;
    }

    public String getAsString() {
        return this.toString();
    }

    public Number getAsNumber() {
        return this.isNumber() ? (Number)((Number)this.getValue()) : (Number)null;
    }

    public boolean getAsBoolean() {
        return !this.isNull();
    }

    public static JsonLikeArray asArray(JsonLikeValue element) {
        if (element != null) {
            return element.getAsArray();
        }
        return null;
    }

    public static JsonLikeObject asObject(JsonLikeValue element) {
        if (element != null) {
            return element.getAsObject();
        }
        return null;
    }

    public static String asString(JsonLikeValue element) {
        if (element != null) {
            return element.getAsString();
        }
        return null;
    }

    public static boolean asBoolean(JsonLikeValue element) {
        if (element != null) {
            return element.getAsBoolean();
        }
        return false;
    }

    public static enum ScalarType {
        NUMBER,
        STRING,
        BOOLEAN;

    }

    public static enum ValueType {
        ARRAY,
        OBJECT,
        SCALAR,
        NULL;

    }
}

