/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.i18n;

import ca.uhn.fhir.context.ConfigurationException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HapiLocalizer {
    public static final String UNKNOWN_I18N_KEY_MESSAGE = "!MESSAGE!";
    private static final Logger ourLog = LoggerFactory.getLogger(HapiLocalizer.class);
    private static boolean ourFailOnMissingMessage;
    private final Map<String, MessageFormat> myKeyToMessageFormat = new ConcurrentHashMap<String, MessageFormat>();
    private List<ResourceBundle> myBundle = new ArrayList<ResourceBundle>();
    private String[] myBundleNames;

    public HapiLocalizer() {
        this(HapiLocalizer.class.getPackage().getName() + ".hapi-messages");
    }

    public HapiLocalizer(String ... theBundleNames) {
        this.myBundleNames = theBundleNames;
        this.init();
    }

    public Set<String> getAllKeys() {
        HashSet<String> retVal = new HashSet<String>();
        for (ResourceBundle nextBundle : this.myBundle) {
            Enumeration<String> keysEnum = nextBundle.getKeys();
            while (keysEnum.hasMoreElements()) {
                retVal.add(keysEnum.nextElement());
            }
        }
        return retVal;
    }

    public String getFormatString(String theQualifiedKey) {
        String formatString = null;
        for (ResourceBundle nextBundle : this.myBundle) {
            if (nextBundle.containsKey(theQualifiedKey)) {
                formatString = nextBundle.getString(theQualifiedKey);
                formatString = StringUtils.trim((String)formatString);
            }
            if (!StringUtils.isNotBlank(formatString)) continue;
            break;
        }
        if (formatString == null) {
            ourLog.warn("Unknown localization key: {}", (Object)theQualifiedKey);
            if (ourFailOnMissingMessage) {
                throw new ConfigurationException("Unknown localization key: " + theQualifiedKey);
            }
            formatString = UNKNOWN_I18N_KEY_MESSAGE;
        }
        return formatString;
    }

    public String getMessage(Class<?> theType, String theKey, Object ... theParameters) {
        return this.getMessage(HapiLocalizer.toKey(theType, theKey), theParameters);
    }

    public String getMessage(String theQualifiedKey, Object ... theParameters) {
        if (theParameters != null && theParameters.length > 0) {
            MessageFormat format = this.myKeyToMessageFormat.get(theQualifiedKey);
            if (format != null) {
                return format.format(theParameters);
            }
            String formatString = this.getFormatString(theQualifiedKey);
            format = new MessageFormat(formatString.trim());
            this.myKeyToMessageFormat.put(theQualifiedKey, format);
            return format.format(theParameters);
        }
        return this.getFormatString(theQualifiedKey);
    }

    protected void init() {
        for (String nextName : this.myBundleNames) {
            this.myBundle.add(ResourceBundle.getBundle(nextName));
        }
    }

    public static void setOurFailOnMissingMessage(boolean ourFailOnMissingMessage) {
        HapiLocalizer.ourFailOnMissingMessage = ourFailOnMissingMessage;
    }

    public static String toKey(Class<?> theType, String theKey) {
        return theType.getName() + '.' + theKey;
    }
}

