/*
 * Decompiled with CFR 0.152.
 */
package build.buf.protovalidate;

import build.buf.protovalidate.Config;
import build.buf.protovalidate.Evaluator;
import build.buf.protovalidate.EvaluatorBuilder;
import build.buf.protovalidate.MessageValue;
import build.buf.protovalidate.RuleViolation;
import build.buf.protovalidate.ValidateLibrary;
import build.buf.protovalidate.ValidationResult;
import build.buf.protovalidate.Validator;
import build.buf.protovalidate.Violation;
import build.buf.protovalidate.exceptions.CompilationException;
import build.buf.protovalidate.exceptions.ValidationException;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import dev.cel.bundle.Cel;
import dev.cel.bundle.CelFactory;
import dev.cel.common.CelOptions;
import dev.cel.compiler.CelCompilerLibrary;
import dev.cel.runtime.CelRuntimeLibrary;
import java.util.ArrayList;
import java.util.List;

final class ValidatorImpl
implements Validator {
    private final EvaluatorBuilder evaluatorBuilder;
    private final boolean failFast;

    ValidatorImpl(Config config) {
        ValidateLibrary validateLibrary = new ValidateLibrary();
        Cel cel = CelFactory.standardCelBuilder().addCompilerLibraries(new CelCompilerLibrary[]{validateLibrary}).addRuntimeLibraries(new CelRuntimeLibrary[]{validateLibrary}).setOptions(CelOptions.DEFAULT.toBuilder().evaluateCanonicalTypesToNativeValues(true).build()).build();
        this.evaluatorBuilder = new EvaluatorBuilder(cel, config);
        this.failFast = config.isFailFast();
    }

    ValidatorImpl(Config config, List<Descriptors.Descriptor> descriptors, boolean disableLazy) throws CompilationException {
        ValidateLibrary validateLibrary = new ValidateLibrary();
        Cel cel = CelFactory.standardCelBuilder().addCompilerLibraries(new CelCompilerLibrary[]{validateLibrary}).addRuntimeLibraries(new CelRuntimeLibrary[]{validateLibrary}).setOptions(CelOptions.DEFAULT.toBuilder().evaluateCanonicalTypesToNativeValues(true).build()).build();
        this.evaluatorBuilder = new EvaluatorBuilder(cel, config, descriptors, disableLazy);
        this.failFast = config.isFailFast();
    }

    @Override
    public ValidationResult validate(Message msg) throws ValidationException {
        if (msg == null) {
            return ValidationResult.EMPTY;
        }
        Descriptors.Descriptor descriptor = msg.getDescriptorForType();
        Evaluator evaluator = this.evaluatorBuilder.load(descriptor);
        List<RuleViolation.Builder> result = evaluator.evaluate(new MessageValue(msg), this.failFast);
        if (result.isEmpty()) {
            return ValidationResult.EMPTY;
        }
        ArrayList<Violation> violations = new ArrayList<Violation>(result.size());
        for (RuleViolation.Builder builder : result) {
            violations.add(builder.build());
        }
        return new ValidationResult(violations);
    }
}

