/*
 * Decompiled with CFR 0.152.
 */
package build.buf.protovalidate;

import build.buf.protovalidate.Expression;
import build.buf.protovalidate.RuleViolation;
import build.buf.protovalidate.Value;
import build.buf.protovalidate.exceptions.ExecutionException;
import build.buf.validate.FieldPath;
import dev.cel.runtime.CelEvaluationException;
import dev.cel.runtime.CelRuntime;
import dev.cel.runtime.CelVariableResolver;
import org.jspecify.annotations.Nullable;

final class CompiledProgram {
    private final CelRuntime.Program program;
    private final Expression source;
    private final @Nullable FieldPath rulePath;
    private final @Nullable Value ruleValue;
    private final @Nullable CelVariableResolver globals;

    CompiledProgram(CelRuntime.Program program, Expression source, @Nullable FieldPath rulePath, @Nullable Value ruleValue, @Nullable CelVariableResolver globals) {
        this.program = program;
        this.source = source;
        this.rulePath = rulePath;
        this.ruleValue = ruleValue;
        this.globals = globals;
    }

    @Nullable RuleViolation.Builder eval(Value fieldValue, CelVariableResolver variables) throws ExecutionException {
        Object value;
        try {
            if (this.globals != null) {
                variables = CelVariableResolver.hierarchicalVariableResolver((CelVariableResolver)variables, (CelVariableResolver)this.globals);
            }
            value = this.program.eval(variables);
        }
        catch (CelEvaluationException e) {
            throw new ExecutionException(String.format("error evaluating %s: %s", new Object[]{this.source.id, e}));
        }
        if (value instanceof String) {
            if ("".equals(value)) {
                return null;
            }
            RuleViolation.Builder builder = RuleViolation.newBuilder().setRuleId(this.source.id).setMessage(value.toString());
            if (fieldValue.fieldDescriptor() != null) {
                builder.setFieldValue(new RuleViolation.FieldValue(fieldValue));
            }
            if (this.rulePath != null) {
                builder.addAllRulePathElements(this.rulePath.getElementsList());
            }
            if (this.ruleValue != null && this.ruleValue.fieldDescriptor() != null) {
                builder.setRuleValue(new RuleViolation.FieldValue(this.ruleValue));
            }
            return builder;
        }
        if (value instanceof Boolean) {
            if (Boolean.TRUE.equals(value)) {
                return null;
            }
            String message = this.source.message;
            if (message.isEmpty()) {
                message = String.format("\"%s\" returned false", this.source.expression);
            }
            RuleViolation.Builder builder = RuleViolation.newBuilder().setRuleId(this.source.id).setMessage(message);
            if (this.rulePath != null) {
                builder.addAllRulePathElements(this.rulePath.getElementsList());
            }
            if (this.ruleValue != null && this.ruleValue.fieldDescriptor() != null) {
                builder.setRuleValue(new RuleViolation.FieldValue(this.ruleValue));
            }
            return builder;
        }
        throw new ExecutionException(String.format("resolved to an unexpected type %s", value));
    }
}

