/*
 * Decompiled with CFR 0.152.
 */
package tests.harness.cases;

import com.google.protobuf.ProtocolMessageEnum;
import io.envoyproxy.pgv.CollectiveValidation;
import io.envoyproxy.pgv.ConstantValidation;
import io.envoyproxy.pgv.EnumValidation;
import io.envoyproxy.pgv.MapValidation;
import io.envoyproxy.pgv.RepeatedValidation;
import io.envoyproxy.pgv.ValidationException;
import io.envoyproxy.pgv.ValidatorImpl;
import io.envoyproxy.pgv.ValidatorIndex;
import tests.harness.cases.Enums;
import tests.harness.cases.other_package.EmbedOuterClass;
import tests.harness.cases.sort.Sort;
import tests.harness.cases.yet_another_package.EmbedOuterClass;

public class EnumsValidator {
    public static ValidatorImpl validatorFor(Class clazz) {
        if (clazz.equals(Enums.EnumNone.class)) {
            return new EnumNoneValidator();
        }
        if (clazz.equals(Enums.EnumConst.class)) {
            return new EnumConstValidator();
        }
        if (clazz.equals(Enums.EnumAliasConst.class)) {
            return new EnumAliasConstValidator();
        }
        if (clazz.equals(Enums.EnumDefined.class)) {
            return new EnumDefinedValidator();
        }
        if (clazz.equals(Enums.EnumAliasDefined.class)) {
            return new EnumAliasDefinedValidator();
        }
        if (clazz.equals(Enums.EnumIn.class)) {
            return new EnumInValidator();
        }
        if (clazz.equals(Enums.EnumAliasIn.class)) {
            return new EnumAliasInValidator();
        }
        if (clazz.equals(Enums.EnumNotIn.class)) {
            return new EnumNotInValidator();
        }
        if (clazz.equals(Enums.EnumAliasNotIn.class)) {
            return new EnumAliasNotInValidator();
        }
        if (clazz.equals(Enums.EnumExternal.class)) {
            return new EnumExternalValidator();
        }
        if (clazz.equals(Enums.EnumExternal2.class)) {
            return new EnumExternal2Validator();
        }
        if (clazz.equals(Enums.EnumExternal3.class)) {
            return new EnumExternal3Validator();
        }
        if (clazz.equals(Enums.EnumExternal4.class)) {
            return new EnumExternal4Validator();
        }
        if (clazz.equals(Enums.RepeatedEnumDefined.class)) {
            return new RepeatedEnumDefinedValidator();
        }
        if (clazz.equals(Enums.RepeatedExternalEnumDefined.class)) {
            return new RepeatedExternalEnumDefinedValidator();
        }
        if (clazz.equals(Enums.RepeatedYetAnotherExternalEnumDefined.class)) {
            return new RepeatedYetAnotherExternalEnumDefinedValidator();
        }
        if (clazz.equals(Enums.RepeatedEnumExternal.class)) {
            return new RepeatedEnumExternalValidator();
        }
        if (clazz.equals(Enums.MapEnumDefined.class)) {
            return new MapEnumDefinedValidator();
        }
        if (clazz.equals(Enums.MapExternalEnumDefined.class)) {
            return new MapExternalEnumDefinedValidator();
        }
        if (clazz.equals(Enums.EnumInsideOneOf.class)) {
            return new EnumInsideOneOfValidator();
        }
        return null;
    }

    public static class EnumNoneValidator
    implements ValidatorImpl<Enums.EnumNone> {
        public void assertValid(Enums.EnumNone proto, ValidatorIndex index) throws ValidationException {
        }
    }

    public static class EnumConstValidator
    implements ValidatorImpl<Enums.EnumConst> {
        public void assertValid(Enums.EnumConst proto, ValidatorIndex index) throws ValidationException {
            ConstantValidation.constant((String)".tests.harness.cases.EnumConst.val", (Object)((Object)proto.getVal()), (Object)((Object)Enums.TestEnum.forNumber(2)));
        }
    }

    public static class EnumAliasConstValidator
    implements ValidatorImpl<Enums.EnumAliasConst> {
        public void assertValid(Enums.EnumAliasConst proto, ValidatorIndex index) throws ValidationException {
            ConstantValidation.constant((String)".tests.harness.cases.EnumAliasConst.val", (Object)((Object)proto.getVal()), (Object)((Object)Enums.TestEnumAlias.forNumber(2)));
        }
    }

    public static class EnumDefinedValidator
    implements ValidatorImpl<Enums.EnumDefined> {
        public void assertValid(Enums.EnumDefined proto, ValidatorIndex index) throws ValidationException {
            EnumValidation.definedOnly((String)".tests.harness.cases.EnumDefined.val", (ProtocolMessageEnum)proto.getVal());
        }
    }

    public static class EnumAliasDefinedValidator
    implements ValidatorImpl<Enums.EnumAliasDefined> {
        public void assertValid(Enums.EnumAliasDefined proto, ValidatorIndex index) throws ValidationException {
            EnumValidation.definedOnly((String)".tests.harness.cases.EnumAliasDefined.val", (ProtocolMessageEnum)proto.getVal());
        }
    }

    public static class EnumInValidator
    implements ValidatorImpl<Enums.EnumIn> {
        private final Enums.TestEnum[] VAL__IN = new Enums.TestEnum[]{Enums.TestEnum.forNumber(0), Enums.TestEnum.forNumber(2)};

        public void assertValid(Enums.EnumIn proto, ValidatorIndex index) throws ValidationException {
            CollectiveValidation.in((String)".tests.harness.cases.EnumIn.val", (Object)((Object)proto.getVal()), (Object[])this.VAL__IN);
        }
    }

    public static class EnumAliasInValidator
    implements ValidatorImpl<Enums.EnumAliasIn> {
        private final Enums.TestEnumAlias[] VAL__IN = new Enums.TestEnumAlias[]{Enums.TestEnumAlias.forNumber(0), Enums.TestEnumAlias.forNumber(2)};

        public void assertValid(Enums.EnumAliasIn proto, ValidatorIndex index) throws ValidationException {
            CollectiveValidation.in((String)".tests.harness.cases.EnumAliasIn.val", (Object)((Object)proto.getVal()), (Object[])this.VAL__IN);
        }
    }

    public static class EnumNotInValidator
    implements ValidatorImpl<Enums.EnumNotIn> {
        private final Enums.TestEnum[] VAL__NOT_IN = new Enums.TestEnum[]{Enums.TestEnum.forNumber(1)};

        public void assertValid(Enums.EnumNotIn proto, ValidatorIndex index) throws ValidationException {
            CollectiveValidation.notIn((String)".tests.harness.cases.EnumNotIn.val", (Object)((Object)proto.getVal()), (Object[])this.VAL__NOT_IN);
        }
    }

    public static class EnumAliasNotInValidator
    implements ValidatorImpl<Enums.EnumAliasNotIn> {
        private final Enums.TestEnumAlias[] VAL__NOT_IN = new Enums.TestEnumAlias[]{Enums.TestEnumAlias.forNumber(1)};

        public void assertValid(Enums.EnumAliasNotIn proto, ValidatorIndex index) throws ValidationException {
            CollectiveValidation.notIn((String)".tests.harness.cases.EnumAliasNotIn.val", (Object)((Object)proto.getVal()), (Object[])this.VAL__NOT_IN);
        }
    }

    public static class EnumExternalValidator
    implements ValidatorImpl<Enums.EnumExternal> {
        public void assertValid(Enums.EnumExternal proto, ValidatorIndex index) throws ValidationException {
            EnumValidation.definedOnly((String)".tests.harness.cases.EnumExternal.val", (ProtocolMessageEnum)proto.getVal());
        }
    }

    public static class EnumExternal2Validator
    implements ValidatorImpl<Enums.EnumExternal2> {
        public void assertValid(Enums.EnumExternal2 proto, ValidatorIndex index) throws ValidationException {
            EnumValidation.definedOnly((String)".tests.harness.cases.EnumExternal2.val", (ProtocolMessageEnum)proto.getVal());
        }
    }

    public static class EnumExternal3Validator
    implements ValidatorImpl<Enums.EnumExternal3> {
        private final EmbedOuterClass.Embed.FooNumber[] FOO__IN = new EmbedOuterClass.Embed.FooNumber[]{EmbedOuterClass.Embed.FooNumber.forNumber(0), EmbedOuterClass.Embed.FooNumber.forNumber(2)};
        private final EmbedOuterClass.Embed.BarNumber[] BAR__NOT_IN = new EmbedOuterClass.Embed.BarNumber[]{EmbedOuterClass.Embed.BarNumber.forNumber(1)};

        public void assertValid(Enums.EnumExternal3 proto, ValidatorIndex index) throws ValidationException {
            CollectiveValidation.in((String)".tests.harness.cases.EnumExternal3.foo", (Object)((Object)proto.getFoo()), (Object[])this.FOO__IN);
            CollectiveValidation.notIn((String)".tests.harness.cases.EnumExternal3.bar", (Object)((Object)proto.getBar()), (Object[])this.BAR__NOT_IN);
        }
    }

    public static class EnumExternal4Validator
    implements ValidatorImpl<Enums.EnumExternal4> {
        public void assertValid(Enums.EnumExternal4 proto, ValidatorIndex index) throws ValidationException {
            ConstantValidation.constant((String)".tests.harness.cases.EnumExternal4.sort_direction", (Object)((Object)proto.getSortDirection()), (Object)((Object)Sort.Direction.forNumber(1)));
        }
    }

    public static class RepeatedEnumDefinedValidator
    implements ValidatorImpl<Enums.RepeatedEnumDefined> {
        public void assertValid(Enums.RepeatedEnumDefined proto, ValidatorIndex index) throws ValidationException {
            RepeatedValidation.forEach(proto.getValList(), item -> EnumValidation.definedOnly((String)".tests.harness.cases.RepeatedEnumDefined.val", (ProtocolMessageEnum)item));
        }
    }

    public static class RepeatedExternalEnumDefinedValidator
    implements ValidatorImpl<Enums.RepeatedExternalEnumDefined> {
        public void assertValid(Enums.RepeatedExternalEnumDefined proto, ValidatorIndex index) throws ValidationException {
            RepeatedValidation.forEach(proto.getValList(), item -> EnumValidation.definedOnly((String)".tests.harness.cases.RepeatedExternalEnumDefined.val", (ProtocolMessageEnum)item));
        }
    }

    public static class RepeatedYetAnotherExternalEnumDefinedValidator
    implements ValidatorImpl<Enums.RepeatedYetAnotherExternalEnumDefined> {
        public void assertValid(Enums.RepeatedYetAnotherExternalEnumDefined proto, ValidatorIndex index) throws ValidationException {
            RepeatedValidation.forEach(proto.getValList(), item -> EnumValidation.definedOnly((String)".tests.harness.cases.RepeatedYetAnotherExternalEnumDefined.val", (ProtocolMessageEnum)item));
        }
    }

    public static class RepeatedEnumExternalValidator
    implements ValidatorImpl<Enums.RepeatedEnumExternal> {
        private final EmbedOuterClass.Embed.FooNumber[] FOO__IN = new EmbedOuterClass.Embed.FooNumber[]{EmbedOuterClass.Embed.FooNumber.forNumber(0), EmbedOuterClass.Embed.FooNumber.forNumber(2)};
        private final EmbedOuterClass.Embed.BarNumber[] BAR__NOT_IN = new EmbedOuterClass.Embed.BarNumber[]{EmbedOuterClass.Embed.BarNumber.forNumber(1)};

        public void assertValid(Enums.RepeatedEnumExternal proto, ValidatorIndex index) throws ValidationException {
            RepeatedValidation.forEach(proto.getFooList(), item -> CollectiveValidation.in((String)".tests.harness.cases.RepeatedEnumExternal.foo", (Object)item, (Object[])this.FOO__IN));
            RepeatedValidation.forEach(proto.getBarList(), item -> CollectiveValidation.notIn((String)".tests.harness.cases.RepeatedEnumExternal.bar", (Object)item, (Object[])this.BAR__NOT_IN));
        }
    }

    public static class MapEnumDefinedValidator
    implements ValidatorImpl<Enums.MapEnumDefined> {
        public void assertValid(Enums.MapEnumDefined proto, ValidatorIndex index) throws ValidationException {
            MapValidation.validateParts(proto.getValMap().keySet(), key -> {});
            MapValidation.validateParts(proto.getValMap().values(), value -> EnumValidation.definedOnly((String)".tests.harness.cases.MapEnumDefined.val", (ProtocolMessageEnum)value));
        }
    }

    public static class MapExternalEnumDefinedValidator
    implements ValidatorImpl<Enums.MapExternalEnumDefined> {
        public void assertValid(Enums.MapExternalEnumDefined proto, ValidatorIndex index) throws ValidationException {
            MapValidation.validateParts(proto.getValMap().keySet(), key -> {});
            MapValidation.validateParts(proto.getValMap().values(), value -> EnumValidation.definedOnly((String)".tests.harness.cases.MapExternalEnumDefined.val", (ProtocolMessageEnum)value));
        }
    }

    public static class EnumInsideOneOfValidator
    implements ValidatorImpl<Enums.EnumInsideOneOf> {
        private final Enums.TestEnum[] VAL_2__NOT_IN = new Enums.TestEnum[]{Enums.TestEnum.forNumber(0)};

        public void assertValid(Enums.EnumInsideOneOf proto, ValidatorIndex index) throws ValidationException {
            switch (proto.getFooCase()) {
                case VAL: {
                    EnumValidation.definedOnly((String)".tests.harness.cases.EnumInsideOneOf.val", (ProtocolMessageEnum)proto.getVal());
                }
            }
            switch (proto.getBarCase()) {
                case VAL2: {
                    EnumValidation.definedOnly((String)".tests.harness.cases.EnumInsideOneOf.val2", (ProtocolMessageEnum)proto.getVal2());
                    CollectiveValidation.notIn((String)".tests.harness.cases.EnumInsideOneOf.val2", (Object)((Object)proto.getVal2()), (Object[])this.VAL_2__NOT_IN);
                }
            }
        }
    }
}

