/*
 * Decompiled with CFR 0.152.
 */
package br.com.tattobr.android.adsanalytics;

import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import br.com.tattobr.android.adsanalytics.BaseApplication;
import br.com.tattobr.android.adsanalytics.R;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdView;
import com.google.android.gms.ads.InterstitialAd;

public abstract class BaseActivity
extends AppCompatActivity {
    private final String SI_SHOW_INTERSTITIAL_AD = "br.com.tattobr.android.adsanalytics.SI_SHOW_INTERSTITIAL_AD";
    private AdView mAdView;
    private boolean mShowInterstitialAd;
    private boolean mSetupAdsCalled;

    public abstract String getIntersticialAdUnitId();

    public boolean showInterstitialAd(boolean persistOnResume) {
        BaseApplication application = (BaseApplication)this.getApplication();
        boolean isShowing = false;
        if (application != null) {
            InterstitialAd interstitialAd = application.getInterstitialAd();
            if (interstitialAd != null && interstitialAd.isLoaded()) {
                this.mShowInterstitialAd = false;
                interstitialAd.show();
                isShowing = true;
            } else {
                this.mShowInterstitialAd = persistOnResume;
            }
        }
        return isShowing;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mShowInterstitialAd = savedInstanceState != null && savedInstanceState.getBoolean("br.com.tattobr.android.adsanalytics.SI_SHOW_INTERSTITIAL_AD");
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putBoolean("br.com.tattobr.android.adsanalytics.SI_SHOW_INTERSTITIAL_AD", this.mShowInterstitialAd);
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.mAdView != null) {
            this.mAdView.destroy();
        }
    }

    protected void onPause() {
        super.onPause();
        if (this.mAdView != null) {
            this.mAdView.pause();
        }
    }

    protected void onResume() {
        super.onResume();
        if (!this.mSetupAdsCalled) {
            throw new IllegalStateException("must call setupAds on onCreate.");
        }
        if (this.mAdView != null) {
            this.mAdView.resume();
        }
        if (this.mShowInterstitialAd) {
            this.showInterstitialAd(true);
        }
    }

    protected final void setupAds() {
        if (!this.mSetupAdsCalled) {
            BaseApplication application;
            String adUnitId;
            this.mSetupAdsCalled = true;
            this.mAdView = (AdView)this.findViewById(R.id.adView);
            if (this.mAdView != null) {
                AdRequest adRequest = this.createDefaultAdRequest();
                this.mAdView.setAdListener(new AdListener(){

                    public void onAdFailedToLoad(int errorCode) {
                        super.onAdFailedToLoad(errorCode);
                        if (errorCode == 2) {
                            BaseActivity.this.mAdView.setVisibility(8);
                        }
                    }
                });
                this.mAdView.loadAd(adRequest);
            }
            if ((adUnitId = this.getIntersticialAdUnitId()) != null && (application = (BaseApplication)this.getApplication()) != null) {
                application.setupInterstitialAd(adUnitId);
            }
        }
    }

    private AdRequest createDefaultAdRequest() {
        BaseApplication application = (BaseApplication)this.getApplication();
        return application != null ? application.createDefaultAdRequest() : null;
    }
}

