/*
 * Decompiled with CFR 0.152.
 */
package br.com.softplan.security.zap.zaproxy.clientapi.core;

import br.com.softplan.security.zap.zaproxy.clientapi.core.ApiResponse;
import br.com.softplan.security.zap.zaproxy.clientapi.core.ApiResponseFactory;
import br.com.softplan.security.zap.zaproxy.clientapi.core.ClientApiException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;

public class ApiResponseList
extends ApiResponse {
    private List<ApiResponse> list = null;

    public ApiResponseList(String name) {
        super(name);
        this.list = new ArrayList<ApiResponse>();
    }

    public ApiResponseList(Node node) throws ClientApiException {
        this(node.getNodeName());
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            this.addItem(ApiResponseFactory.getResponse(child));
        }
    }

    public ApiResponseList(Node node, ApiResponseList template) throws ClientApiException {
        super(node.getNodeName());
        try {
            this.list = new ArrayList<ApiResponse>();
            Class<? extends ApiResponse> clazz = template.getItemsClass();
            if (clazz != null) {
                for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    Constructor<? extends ApiResponse> cons = clazz.getConstructor(Node.class, ApiResponse.class);
                    this.addItem(cons.newInstance(child, template.list.get(0)));
                }
            }
        }
        catch (Exception e) {
            throw new ClientApiException(e);
        }
    }

    public ApiResponseList(String name, ApiResponse[] array) {
        super(name);
        this.list = new ArrayList<ApiResponse>();
        for (ApiResponse resp : array) {
            this.list.add(resp);
        }
    }

    public ApiResponseList(String name, List<ApiResponse> list) {
        super(name);
        this.list = list;
    }

    public void addItem(ApiResponse item) {
        this.list.add(item);
    }

    public List<ApiResponse> getItems() {
        return this.list;
    }

    public Class<? extends ApiResponse> getItemsClass() {
        if (this.list == null || this.list.size() == 0) {
            return null;
        }
        return this.list.get(0).getClass();
    }

    @Override
    public String toString(int indent) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            sb.append("\t");
        }
        sb.append("ApiResponseList ");
        sb.append(this.getName());
        sb.append(" : [\n");
        for (ApiResponse resp : this.list) {
            sb.append(resp.toString(indent + 1));
        }
        for (int i = 0; i < indent; ++i) {
            sb.append("\t");
        }
        sb.append("]\n");
        return sb.toString();
    }
}

