/*
 * Decompiled with CFR 0.152.
 */
package br.com.softplan.security.zap.api.model;

import br.com.softplan.security.zap.api.model.AnalysisType;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class AnalysisInfo {
    private static final long DEFAULT_ANALYSIS_TIMEOUT_IN_MINUTES = 480L;
    private static final AnalysisType DEFAULT_ANALYSIS_TYPE = AnalysisType.WITH_SPIDER;
    private static final boolean DEFAULT_SHOULD_START_NEW_SESSION = true;
    private String targetUrl;
    private String spiderStartingPointUrl;
    private String activeScanStartingPointUrl;
    private String[] context;
    private String[] technologies;
    private String technologiesSeparatedByComma;
    private long analysisTimeoutInMinutes;
    private AnalysisType analysisType;
    private boolean shouldStartNewSession;

    public static Builder builder() {
        return new Builder();
    }

    public String getTargetUrl() {
        return this.targetUrl;
    }

    public String getSpiderStartingPointUrl() {
        if (this.spiderStartingPointUrl != null) {
            return this.spiderStartingPointUrl;
        }
        return this.targetUrl;
    }

    public String getActiveScanStartingPointUrl() {
        if (this.activeScanStartingPointUrl != null) {
            return this.activeScanStartingPointUrl;
        }
        return this.targetUrl;
    }

    public String[] getContext() {
        if (this.context != null && this.context.length > 0) {
            return this.context;
        }
        return new String[]{this.targetUrl};
    }

    public String[] getTechnologies() {
        return this.technologies;
    }

    public String getTechnologiesSeparatedByComma() {
        return this.technologiesSeparatedByComma;
    }

    public long getAnalysisTimeoutInMillis() {
        return TimeUnit.MILLISECONDS.convert(this.analysisTimeoutInMinutes, TimeUnit.MINUTES);
    }

    public long getAnalysisTimeoutInMinutes() {
        return this.analysisTimeoutInMinutes;
    }

    public AnalysisType getAnalysisType() {
        return this.analysisType;
    }

    public boolean shouldStartNewSession() {
        return this.shouldStartNewSession;
    }

    private AnalysisInfo(Builder builder) {
        this.targetUrl = builder.targetUrl;
        this.spiderStartingPointUrl = builder.spiderStartingPointUrl;
        this.activeScanStartingPointUrl = builder.activeScanStartingPointUrl;
        this.context = builder.context;
        this.technologies = builder.technologies;
        this.technologiesSeparatedByComma = builder.technologiesSeparatedByComma;
        this.analysisTimeoutInMinutes = builder.analysisTimeoutInMinutes;
        this.analysisType = builder.analysisType;
        this.shouldStartNewSession = builder.shouldStartNewSession;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("targetUrl", (Object)this.targetUrl).append("spiderStartingPointUrl", (Object)this.spiderStartingPointUrl).append("activeScanStartingPointUrl", (Object)this.activeScanStartingPointUrl).append("context", (Object)Arrays.toString(this.context)).append("technologies", (Object)Arrays.toString(this.technologies)).append("analysisTimeoutInMinutes", this.analysisTimeoutInMinutes).append("analysisType", (Object)this.analysisType).append("shouldStartNewSession", this.shouldStartNewSession).toString();
    }

    static /* synthetic */ AnalysisType access$000() {
        return DEFAULT_ANALYSIS_TYPE;
    }

    public static class Builder {
        private String targetUrl;
        private String spiderStartingPointUrl;
        private String activeScanStartingPointUrl;
        private String[] context;
        private String[] technologies;
        private String technologiesSeparatedByComma;
        private long analysisTimeoutInMinutes = 480L;
        private AnalysisType analysisType = AnalysisInfo.access$000();
        private boolean shouldStartNewSession = true;

        public Builder targetUrl(String targetUrl) {
            this.targetUrl = targetUrl;
            return this;
        }

        public Builder spiderStartingPointUrl(String spiderStartingPointUrl) {
            this.spiderStartingPointUrl = spiderStartingPointUrl;
            return this;
        }

        public Builder activeScanStartingPointUrl(String activeScanStartingPointUrl) {
            this.activeScanStartingPointUrl = activeScanStartingPointUrl;
            return this;
        }

        public Builder context(String ... context) {
            this.context = context;
            return this;
        }

        public Builder technologies(String ... technologies) {
            this.technologies = technologies;
            this.technologiesSeparatedByComma = technologies != null ? StringUtils.join((Object[])technologies, (String)",") : null;
            return this;
        }

        public Builder analysisTimeoutInMinutes(long analysisTimeoutInMinutes) {
            this.analysisTimeoutInMinutes = analysisTimeoutInMinutes;
            return this;
        }

        public Builder analysisType(AnalysisType analysisType) {
            this.analysisType = analysisType;
            return this;
        }

        public Builder analysisType(String analysisType) {
            if (analysisType != null) {
                this.analysisType = AnalysisType.valueOf(analysisType.toUpperCase());
            }
            return this;
        }

        public Builder shouldStartNewSession(boolean shouldStartNewSession) {
            this.shouldStartNewSession = shouldStartNewSession;
            return this;
        }

        public AnalysisInfo build() {
            return new AnalysisInfo(this);
        }
    }
}

