/*
 * Decompiled with CFR 0.152.
 */
package br.com.six2six.bfgex.interpreter;

import br.com.six2six.bfgex.RandomGen;
import br.com.six2six.bfgex.interpreter.Exp;
import br.com.six2six.bfgex.interpreter.Quantifier;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.commons.lang.CharRange;
import org.apache.commons.lang.StringUtils;

public class Sexp {
    private LinkedList<Object> expressions = new LinkedList();

    public Sexp(Exp exp) {
        this.expressions.add((Object)exp);
    }

    public LinkedList<Object> getValues() {
        return this.expressions;
    }

    public Sexp add(Object value) {
        this.expressions.add(value);
        return this;
    }

    public Sexp addAll(Object[] arrayValue) {
        this.expressions.addAll(Arrays.asList(arrayValue));
        return this;
    }

    public Object first() {
        return this.expressions.size() > 0 ? this.expressions.get(0) : null;
    }

    public Object removeLast() {
        return this.expressions.removeLast();
    }

    public String reduce() {
        return (String)this.reduce(this.getValues());
    }

    private Object reduce(LinkedList<Object> expressions) {
        return this.reduce(expressions, null);
    }

    private Object reduce(LinkedList<Object> expressions, Quantifier quantity) {
        Object result = null;
        if (expressions.getFirst() instanceof Exp) {
            Exp operation = (Exp)((Object)expressions.removeFirst());
            result = this.reduceExp(operation, expressions, quantity);
        } else if (expressions.getFirst() instanceof Sexp) {
            result = this.reduce(((Sexp)expressions.getFirst()).getValues(), quantity);
        }
        return result;
    }

    private Object reduceExp(Exp exp, LinkedList<Object> expressions, Quantifier quantity) {
        Object result = null;
        switch (exp) {
            case UNION: {
                result = this.genValue(StringUtils.join(this.mapReduce(expressions), (String)""), quantity);
                break;
            }
            case INTERSECTION: {
                result = this.genValue(this.reduce(((Sexp)RandomGen.pickCollection(expressions)).getValues()), quantity);
                break;
            }
            case RANDOM: 
            case LITERAL: {
                result = this.genValue(expressions.get(0), quantity);
                break;
            }
            case QUANTIFY: {
                quantity = (Quantifier)expressions.removeLast();
                result = this.reduce(expressions, quantity);
                break;
            }
            case CHARCLASS: {
                result = this.genValue(StringUtils.join(this.mapReduce(expressions), (String)"").split("(?!^)"), quantity == null ? new Quantifier(1) : quantity);
                break;
            }
            case RANGE: {
                result = this.buildCharset(this.mapReduce(expressions));
            }
        }
        return result;
    }

    private String genValue(Object reducedValue, Quantifier quantity) {
        return quantity != null ? quantity.genValue(reducedValue) : (String)reducedValue;
    }

    private LinkedList<Object> mapReduce(LinkedList<Object> expressions) {
        LinkedList<Object> mappedList = new LinkedList<Object>();
        for (Object e : expressions) {
            mappedList.add(this.reduce(((Sexp)e).getValues()));
        }
        return mappedList;
    }

    private String buildCharset(LinkedList<Object> interval) {
        char start = ((String)interval.removeFirst()).charAt(0);
        char end = ((String)interval.removeFirst()).charAt(0);
        Iterator it = new CharRange(start, end).iterator();
        StringBuilder values = new StringBuilder();
        while (it.hasNext()) {
            values.append(it.next());
        }
        return values.toString();
    }

    public String toString() {
        return "(" + StringUtils.join(this.expressions, (String)",") + ")";
    }
}

