/*
 * Decompiled with CFR 0.152.
 */
package br.com.six2six.bfgex;

import br.com.six2six.bfgex.Gender;
import br.com.six2six.bfgex.resource.Dictionary;
import java.util.Collection;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberRange;
import org.apache.commons.lang.math.RandomUtils;
import org.apache.commons.math.random.RandomDataImpl;

public class RandomGen {
    private static NumberRange WORDS_PER_SENTENCE = new NumberRange((Number)3, (Number)20);
    private static NumberRange SENTENCES_PER_PARAGRAPH = new NumberRange((Number)3, (Number)8);

    public static boolean pickBoolean() {
        return RandomUtils.nextBoolean();
    }

    public static String pickChar() {
        return RandomStringUtils.randomAlphabetic((int)1);
    }

    public static String pickLowerChar() {
        return RandomGen.pickChar().toLowerCase();
    }

    public static String pickUpperChar() {
        return RandomGen.pickChar().toUpperCase();
    }

    public static String pickWhiteSpaces(Integer length) {
        return RandomStringUtils.random((int)length, (String)"\t\n\r");
    }

    public static String pickDigits(Integer length) {
        length = RandomGen.getValidLength(length, new NumberRange((Number)1, (Number)10));
        return RandomStringUtils.randomNumeric((int)length);
    }

    public static <T> T pickArray(T[] array) {
        return array[RandomUtils.nextInt((int)array.length)];
    }

    public static <T> T pickOne(T ... args) {
        return RandomGen.pickArray(args);
    }

    public static Number pickRange(NumberRange range) {
        Number result = null;
        RandomDataImpl randomData = new RandomDataImpl();
        if (range.getMinimumNumber() instanceof Integer && range.getMaximumNumber() instanceof Integer) {
            result = randomData.nextInt(range.getMinimumInteger(), range.getMaximumInteger());
        }
        if (range.getMinimumNumber() instanceof Long && range.getMaximumNumber() instanceof Long) {
            result = randomData.nextLong(range.getMinimumLong(), range.getMaximumLong());
        }
        if (range.getMinimumNumber() instanceof Float && range.getMaximumNumber() instanceof Float) {
            result = randomData.nextUniform((double)range.getMinimumFloat(), (double)range.getMaximumFloat());
        }
        if (range.getMinimumNumber() instanceof Double && range.getMaximumNumber() instanceof Double) {
            result = randomData.nextUniform(range.getMinimumDouble(), range.getMaximumDouble());
        }
        return result;
    }

    public static <T> T pickCollection(Collection<T> collection) {
        Object result = null;
        if (collection != null && !collection.isEmpty()) {
            result = RandomGen.pickArray(collection.toArray());
        }
        return (T)result;
    }

    public static String pickAlphaNumeric() {
        return RandomStringUtils.randomAlphanumeric((int)1);
    }

    public static String sentence(Integer length) {
        if (length == null) {
            length = RandomGen.pickRange(WORDS_PER_SENTENCE).intValue();
        }
        Object[] result = new String[length.intValue()];
        for (int i = 0; i < length; ++i) {
            result[i] = RandomGen.word();
        }
        return StringUtils.join((Object[])result, (String)" ");
    }

    public static String sentence() {
        return RandomGen.sentence(null);
    }

    public static String paragraph(Integer length) {
        if (length == null) {
            length = RandomGen.pickRange(SENTENCES_PER_PARAGRAPH).intValue();
        }
        Object[] result = new String[length.intValue()];
        for (int i = 0; i < length; ++i) {
            result[i] = RandomGen.sentence();
        }
        return StringUtils.join((Object[])result, (String)".");
    }

    public static String email(Integer emailLength, String domain) {
        emailLength = RandomGen.getValidLength(emailLength, new NumberRange((Number)3, (Number)40));
        domain = domain == null ? "example.org" : domain;
        return RandomGen.word(emailLength - domain.length() - 1) + "@" + domain;
    }

    public static String email(Integer emailLength) {
        return RandomGen.email(emailLength, null);
    }

    public static String email(String domain) {
        return RandomGen.email(null, domain);
    }

    public static String email() {
        return RandomGen.email(null, null);
    }

    public static String word(Integer length) {
        String word = null;
        word = (length = RandomGen.getValidLength(length, new NumberRange((Number)3, (Number)20))) == 1 ? RandomGen.pickChar() : RandomGen.pickCollection(Dictionary.getWordsByLength(length));
        if (word == null) {
            word = RandomStringUtils.randomAlphanumeric((int)length);
        }
        return word;
    }

    public static String word() {
        return RandomGen.word(null);
    }

    public static String firstName(Integer length, Gender gender) {
        length = RandomGen.getValidLength(length, new NumberRange((Number)3, (Number)10));
        return gender.equals((Object)Gender.MALE) ? RandomGen.pickCollection(Dictionary.getMaleNameByLength(length)) : RandomGen.pickCollection(Dictionary.getFemaleNameByLength(length));
    }

    public static String firstName(Integer length) {
        return RandomGen.firstName(length, RandomGen.pickArray(Gender.values()));
    }

    public static String firstName() {
        return RandomGen.firstName(null, RandomGen.pickArray(Gender.values()));
    }

    public static String firstName(Gender gender) {
        return RandomGen.firstName(null, gender);
    }

    public static String lastName(Integer length) {
        length = RandomGen.getValidLength(length, new NumberRange((Number)3, (Number)10));
        return RandomGen.pickCollection(Dictionary.getLastNameByLength(length));
    }

    public static String lastName() {
        return RandomGen.lastName(null);
    }

    public static String name(Integer length, Gender gender) {
        return RandomGen.firstName(length, gender) + " " + RandomGen.lastName(length);
    }

    public static String name(Gender gender) {
        return RandomGen.firstName(null, gender) + " " + RandomGen.lastName(null);
    }

    public static String name(Integer length) {
        return RandomGen.firstName(length) + " " + RandomGen.lastName(length);
    }

    public static String name() {
        return RandomGen.firstName() + " " + RandomGen.lastName();
    }

    private static Integer getValidLength(Integer length, NumberRange numberRange) {
        if (length == null) {
            length = RandomGen.pickRange(numberRange).intValue();
        }
        return length;
    }
}

