package br.com.six2six.bfgex.interpreter;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;

import org.apache.commons.lang.CharRange;
import org.apache.commons.lang.StringUtils;

import br.com.six2six.bfgex.RandomGen;

public class Sexp {
    private LinkedList<Object> expressions = new LinkedList<Object>();

    public Sexp(Exp exp) {
        expressions.add(exp);
    }
    
    public LinkedList<Object> getValues() {
        return expressions;
    }
    
    public Sexp add(Object value) {
        expressions.add(value);
        return this;
    }
    
    public Sexp addAll(Object[] arrayValue) {
        expressions.addAll(Arrays.asList(arrayValue));
        return this;
    }
    
    public Object first() {
        return expressions.size() > 0 ? expressions.get(0) : null;
    }
    
    public Object removeLast() {
        return expressions.removeLast();
    }

    public String reduce() {
        return (String) reduce(this.getValues());
    }
    
    private Object reduce(LinkedList<Object> expressions) {
    	return this.reduce(expressions, null);
    }
    
    private Object reduce(LinkedList<Object> expressions, Quantifier quantity) {
        Object result = null;
        
        if (expressions.getFirst() instanceof Exp) {
            Exp operation = (Exp) expressions.removeFirst();
        	result = reduceExp(operation, expressions, quantity);
        } else if (expressions.getFirst() instanceof Sexp) {
        	result = reduce(((Sexp) expressions.getFirst()).getValues(), quantity);
        }
        
        return result;
    }
    
    private Object reduceExp(Exp exp, LinkedList<Object> expressions, Quantifier quantity) {
        Object result = null;
        switch (exp) {
        case UNION: 
        	result = genValue(StringUtils.join(mapReduce(expressions), ""), quantity);
        	break;
        case INTERSECTION: 
        	result = genValue(reduce(((Sexp) RandomGen.pickCollection(expressions)).getValues()), quantity); 	
        	break;
        case RANDOM:
        case LITERAL: result = genValue(expressions.get(0), quantity);
        	break;
        case QUANTIFY:
        	quantity = (Quantifier) expressions.removeLast(); 
        	result = reduce(expressions, quantity);
        	break;
        case CHARCLASS:
            result = genValue(StringUtils.join(mapReduce(expressions), "").split("(?!^)"), quantity == null ? new Quantifier(1) : quantity);
            break;
        case RANGE:
            result = buildCharset(mapReduce(expressions));
            break;
        }

        return result;
    }
    
    private String genValue(Object reducedValue, Quantifier quantity) {
    	return quantity != null ? quantity.genValue(reducedValue) : (String) reducedValue;
    }
    
    private LinkedList<Object> mapReduce(LinkedList<Object> expressions) {
    	LinkedList<Object> mappedList = new LinkedList<Object>();
    	for (Object object : expressions) {
			mappedList.add(reduce(((Sexp) object).getValues()));
		}
    	return mappedList;
    }
    
    @SuppressWarnings("unchecked")
    private String buildCharset(LinkedList<Object> interval) {
        char start = ((String) interval.removeFirst()).charAt(0);
        char end = ((String) interval.removeFirst()).charAt(0);
        
        Iterator<Character> it = (Iterator<Character>) new CharRange(start, end).iterator();
        
        StringBuilder values = new StringBuilder();
        while (it.hasNext()) {
            values.append(it.next());
        }
        
        return values.toString();
    }
    
    @Override
    public String toString() {
        return "(" + StringUtils.join(expressions, ",") + ")";
    }
    
}
